<?php
    $isAdmin = isAdmin();

    $user = authCheck();
    $isStudent = isStudent();
    $isInstructor = isInstructor();
    $isOrganization = isOrganization();

    if ($isStudent || $isInstructor || $isOrganization) {
        $userInfo = $user?->userable ?? null;

        $userTranslations = parse_translation($userInfo);

        $email = $user->email ?? '';

        $firstName = $userTranslations['first_name'] ?? ($userInfo?->first_name ?? '');
        $firstName = $userTranslations['last_name'] ?? ($userInfo?->last_name ?? '');
        $orgName = $userTranslations['name'] ?? ($userInfo?->name ?? '');

        $name = isset($userInfo?->first_name, $userInfo?->last_name) ? $firstName . ' ' . $firstName : $orgName;
        $imagePath = userImagePath($user->guard);
    }
?>

<header
    class="header px-4 sm:px-6 h-[calc(theme('spacing.header')_-_10px)] sm:h-header bg-white dark:bg-dark-card rounded-none xl:rounded-10 flex items-center mb-4 xl:m-4 group-data-[sidebar-size=lg]:xl:ml-[calc(theme('spacing.app-menu')_+_32px)] rtl:group-data-[sidebar-size=lg]:xl:ml-4 rtl:group-data-[sidebar-size=lg]:xl:mr-[calc(theme('spacing.app-menu')_+_32px)] group-data-[sidebar-size=sm]:xl:ml-[calc(theme('spacing.app-menu-sm')_+_32px)] rtl:group-data-[sidebar-size=sm]:xl:ml-0 rtl:group-data-[sidebar-size=sm]:xl:mr-[calc(theme('spacing.app-menu-sm')_+_32px)] group-data-[sidebar-size=sm]:group-data-[theme-width=box]:xl:ml-[calc(theme('spacing.app-menu-sm')_+_16px)] rtl:group-data-[sidebar-size=sm]:group-data-[theme-width=box]:xl:ml-0 rtl:group-data-[sidebar-size=sm]:group-data-[theme-width=box]:xl:mr-[calc(theme('spacing.app-menu-sm')_+_16px)] group-data-[theme-width=box]:xl:ml-[calc(theme('spacing.app-menu')_+_16px)] rtl:group-data-[theme-width=box]:xl:ml-0 rtl:group-data-[theme-width=box]:xl:mr-[calc(theme('spacing.app-menu')_+_16px)] group-data-[theme-width=box]:xl:mr-0 xl:dk-theme-card-square duration-300">
    <div class="flex-center-between grow">
        <!-- Header Left -->
        <div class="flex items-center gap-4">
            <div class="menu-hamburger-container flex-center">
                <button type="button" id="app-menu-hamburger"
                    class="menu-hamburger hover:bg-primary hover:text-white hidden xl:block"></button>
                <button type="button" class="menu-hamburger hover:bg-primary hover:text-white block xl:hidden"
                    data-drawer-target="app-drawer" data-drawer-show="app-drawer" aria-controls="app-drawer"></button>
            </div>
        </div>
        <!-- Header Right -->
        <div class="flex items-center gap-3">
            <?php if(count(app('languages')) > 0): ?>
                <div
                    class="flex items-center justify-end space-x-5 divide-x divide-white/15 [&>:not(:first-child)]:pl-5 grow">
                    <div class="flex items-center">
                        <form method="get" action="<?php echo e(route('language.set')); ?>" id="language-form">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="admin_id"
                                value="<?php echo e(auth('admin')->check() ? auth('admin')->user()->id : null); ?>">
                            <input type="hidden" name="user_id"
                                value="<?php echo e(auth()->check() ? auth()->user()->id : null); ?>">
                            <select name="locale" aria-label="Choose Language"
                                onchange="event.preventDefault();
                                document.getElementById('language-form').submit();"
                                class="text-gray-500 dark:text-dark-text dark:bg-dark-card-shade font-semibold bg-transparent focus:outline-none cursor-pointer select-none text-sm border dk-border-one px-2 py-2 rounded-md dk-theme-card-square">
                                <?php $__currentLoopData = app('languages'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($language->code); ?>"
                                        <?php echo e(app()->getLocale() == $language->code ? 'selected' : ''); ?>>
                                        <?php echo e($language->name); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </form>
                    </div>
                </div>
            <?php endif; ?>
            <!-- View Frontend Link -->
            <a href="<?php echo e(route('home.index')); ?>" target="_blank" aria-label="View Site Frontend Link"
                class="relative size-8 hidden sm:flex-center hover:bg-gray-200 dark:hover:bg-dark-icon rounded-md after:absolute after:-top-1.5 after:border-transparent after:border-[6px] after:!border-t-gray-500 after:invisible after:opacity-0 before:absolute before:bottom-[calc(100%_+_6px)] before:content-['Visit_Website'] before:bg-gray-500 before:w-max before:px-2 before:py-1 before:text-white before:rounded-md before:text-xs before:invisible before:opacity-0 before:duration-200 after:duration-200 hover:before:visible hover:before:opacity-100 hover:after:visible hover:after:opacity-100 dk-theme-card-square">
                <i class="ri-eye-fill text-[22px]"></i>
            </a>
            <!-- Light/Dark Button -->
            <button type="button"
                class="themeMode size-8 hidden sm:flex-center hover:bg-gray-200 dark:hover:bg-dark-icon rounded-md dk-theme-card-square"
                onclick="toggleThemeMode()">
                <i class="ri-contrast-2-line text-[22px] group-[.dark]:before:!content-['\f1bf']"></i>
            </button>
            <!-- Settings Button -->
            <button type="button" aria-label="Offcanvas menu settings" data-offcanvas-id="app-settings-sidebar"
                class="size-8 flex-center hover:bg-gray-200 dark:hover:bg-dark-icon rounded-md dk-theme-card-square">
                <i class="ri-settings-3-line text-[22px] animate-spin-slow"></i>
            </button>

            <?php if($isAdmin): ?>
                <?php if (isset($component)) { $__componentOriginalf33d5deb3c82273efbb64ae877c1a568 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalf33d5deb3c82273efbb64ae877c1a568 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => '7ee9c4f86007ba41bc79bbfab1cd8a68::admin.notification','data' => ['readRoute' => ''.e(route('notification.read.all')).'','route' => ''.e(route('notification.history')).'','notifications' => Auth::user()->unreadNotifications,'singleRoute' => 'notification.history.status']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('portal::admin.notification'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['read-route' => ''.e(route('notification.read.all')).'','route' => ''.e(route('notification.history')).'','notifications' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(Auth::user()->unreadNotifications),'singleRoute' => 'notification.history.status']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalf33d5deb3c82273efbb64ae877c1a568)): ?>
<?php $attributes = $__attributesOriginalf33d5deb3c82273efbb64ae877c1a568; ?>
<?php unset($__attributesOriginalf33d5deb3c82273efbb64ae877c1a568); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalf33d5deb3c82273efbb64ae877c1a568)): ?>
<?php $component = $__componentOriginalf33d5deb3c82273efbb64ae877c1a568; ?>
<?php unset($__componentOriginalf33d5deb3c82273efbb64ae877c1a568); ?>
<?php endif; ?>
            <?php endif; ?>
            <?php if($isStudent): ?>
                <?php if (isset($component)) { $__componentOriginalf33d5deb3c82273efbb64ae877c1a568 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalf33d5deb3c82273efbb64ae877c1a568 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => '7ee9c4f86007ba41bc79bbfab1cd8a68::admin.notification','data' => ['readRoute' => ''.e(route('student.notification.read.all')).'','route' => ''.e(route('student.notification.history')).'','notifications' => Auth::user()->unreadNotifications,'singleRoute' => 'student.notification.history.status']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('portal::admin.notification'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['read-route' => ''.e(route('student.notification.read.all')).'','route' => ''.e(route('student.notification.history')).'','notifications' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(Auth::user()->unreadNotifications),'singleRoute' => 'student.notification.history.status']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalf33d5deb3c82273efbb64ae877c1a568)): ?>
<?php $attributes = $__attributesOriginalf33d5deb3c82273efbb64ae877c1a568; ?>
<?php unset($__attributesOriginalf33d5deb3c82273efbb64ae877c1a568); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalf33d5deb3c82273efbb64ae877c1a568)): ?>
<?php $component = $__componentOriginalf33d5deb3c82273efbb64ae877c1a568; ?>
<?php unset($__componentOriginalf33d5deb3c82273efbb64ae877c1a568); ?>
<?php endif; ?>
            <?php endif; ?>
            <?php if($isOrganization): ?>
                <?php if (isset($component)) { $__componentOriginalf33d5deb3c82273efbb64ae877c1a568 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalf33d5deb3c82273efbb64ae877c1a568 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => '7ee9c4f86007ba41bc79bbfab1cd8a68::admin.notification','data' => ['readRoute' => ''.e(route('organization.notification.read.all')).'','route' => ''.e(route('organization.notification.history')).'','notifications' => Auth::user()->unreadNotifications,'singleRoute' => 'organization.notification.history.status']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('portal::admin.notification'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['read-route' => ''.e(route('organization.notification.read.all')).'','route' => ''.e(route('organization.notification.history')).'','notifications' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(Auth::user()->unreadNotifications),'singleRoute' => 'organization.notification.history.status']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalf33d5deb3c82273efbb64ae877c1a568)): ?>
<?php $attributes = $__attributesOriginalf33d5deb3c82273efbb64ae877c1a568; ?>
<?php unset($__attributesOriginalf33d5deb3c82273efbb64ae877c1a568); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalf33d5deb3c82273efbb64ae877c1a568)): ?>
<?php $component = $__componentOriginalf33d5deb3c82273efbb64ae877c1a568; ?>
<?php unset($__componentOriginalf33d5deb3c82273efbb64ae877c1a568); ?>
<?php endif; ?>
            <?php endif; ?>
            <?php if($isInstructor): ?>
                <?php if (isset($component)) { $__componentOriginalf33d5deb3c82273efbb64ae877c1a568 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalf33d5deb3c82273efbb64ae877c1a568 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => '7ee9c4f86007ba41bc79bbfab1cd8a68::admin.notification','data' => ['readRoute' => ''.e(route('instructor.notification.read.all')).'','route' => ''.e(route('instructor.notification.history')).'','notifications' => Auth::user()->unreadNotifications,'singleRoute' => 'instructor.notification.history.status']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('portal::admin.notification'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['read-route' => ''.e(route('instructor.notification.read.all')).'','route' => ''.e(route('instructor.notification.history')).'','notifications' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(Auth::user()->unreadNotifications),'singleRoute' => 'instructor.notification.history.status']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalf33d5deb3c82273efbb64ae877c1a568)): ?>
<?php $attributes = $__attributesOriginalf33d5deb3c82273efbb64ae877c1a568; ?>
<?php unset($__attributesOriginalf33d5deb3c82273efbb64ae877c1a568); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalf33d5deb3c82273efbb64ae877c1a568)): ?>
<?php $component = $__componentOriginalf33d5deb3c82273efbb64ae877c1a568; ?>
<?php unset($__componentOriginalf33d5deb3c82273efbb64ae877c1a568); ?>
<?php endif; ?>
            <?php endif; ?>
            <!-- Border -->
            <div class="w-[1px] h-[calc(theme('spacing.header')_-_10px)] sm:h-header bg-[#EEE] dark:bg-dark-card-shade">
            </div>
            <!-- User Profile Button -->
            <div class="relative">
                <button type="button" data-popover-target="dropdownProfile" data-popover-trigger="click"
                    data-popover-placement="bottom-end" class="flex items-center gap-2">
                    <?php if($isStudent || $isInstructor || $isOrganization): ?>
                        <?php if(fileExists('lms/' . $imagePath, $userInfo->profile_img) == true && $userInfo?->profile_img != ''): ?>
                            <img src="<?php echo e(asset('storage/lms/' . $imagePath . '/' . $userInfo->profile_img)); ?>"
                                alt="cover-image"
                                class="size-9 rounded-50 dk-theme-card-square object-cover object-center">
                        <?php else: ?>
                            <img src="<?php echo e(asset('lms/assets/images/placeholder/profile.jpg')); ?>" alt="user-img"
                                class="size-10 rounded-50 dk-theme-card-square object-cover object-center">
                        <?php endif; ?>
                    <?php endif; ?>
                    <?php if($isAdmin): ?>
                        <?php
                            $profileImg = Auth::guard('admin')->user()->profile_img;
                            $photo =
                                fileExists('lms/admins', $profileImg) == true && $profileImg !== ''
                                    ? asset('storage/lms/admins/' . $profileImg)
                                    : asset('lms/assets/images/placeholder/profile.jpg');
                        ?>

                        <img src="<?php echo e($photo); ?>" alt="user-img"
                            class="size-10 rounded-50 dk-theme-card-square object-cover">
                    <?php endif; ?>
                </button>
                <div id="dropdownProfile"
                    class="invisible z-backdrop bg-white text-left divide-y [&>:last-child:border-t-0] divide-gray-100 rounded-lg shadow w-48 dark:bg-dark-card-shade dark:divide-dark-border-four dk-theme-card-square">
                    <div class="px-4 py-3 text-sm text-gray-500 dark:text-white rtl:text-right">
                        <h6 class="card-title text-lg">
                            <?php if($isStudent || $isInstructor || $isOrganization): ?>
                                <?php echo e($name ?? ''); ?>

                            <?php endif; ?>

                            <?php if($isAdmin): ?>
                                <?php echo e(Auth::guard('admin')->user()->name); ?>

                            <?php endif; ?>
                        </h6>
                        <div class="ext-sm text-gray-500 dark:text-dark-text">
                            <?php if($isAdmin): ?>
                                <div class="truncate"> <?php echo e(Auth::guard('admin')->user()->email); ?></div>
                            <?php endif; ?>
                            <?php if($isStudent || $isInstructor || $isOrganization): ?>
                                <div class="truncate"> <?php echo e($email); ?></div>
                            <?php endif; ?>
                        </div>
                    </div>
                    <ul class="text-sm text-gray-700 dark:text-gray-200">

                        <?php if($isAdmin): ?>
                            <li>
                                <a href="<?php echo e(route('admin.profile')); ?>"
                                    class="flex font-medium px-4 py-2 hover:bg-gray-200 dark:hover:bg-dark-icon dark:hover:text-white">
                                    <?php echo e(translate('My Profile')); ?>

                                </a>
                            </li>
                        <?php endif; ?>
                        <li>
                            <a href="<?php echo e(route('home.index')); ?>" target="_blank"
                                class="flex font-medium px-4 py-2 hover:bg-gray-200 dark:hover:bg-dark-icon dark:hover:text-white">
                                <?php echo e(translate('Visit Website')); ?>

                            </a>
                        </li>

                        <?php if($isStudent): ?>
                            <li>
                                <a href="<?php echo e(route('student.enroll.index')); ?>"
                                    class="flex font-medium px-4 py-2 hover:bg-gray-200 dark:hover:bg-dark-icon dark:hover:text-white">
                                    <?php echo e(translate('My Course')); ?>

                                </a>
                            </li>
                        <?php endif; ?>
                        <?php if($isInstructor): ?>
                            <li>
                                <a href="<?php echo e(route('instructor.setting')); ?>"
                                    class="flex font-medium px-4 py-2 hover:bg-gray-200 dark:hover:bg-dark-icon dark:hover:text-white">
                                    <?php echo e(translate('Setting')); ?>

                                </a>
                            </li>
                        <?php endif; ?>
                        <?php if($isOrganization): ?>
                            <li>
                                <a href="<?php echo e(route('organization.setting')); ?>"
                                    class="flex font-medium px-4 py-2 hover:bg-gray-200 dark:hover:bg-dark-icon dark:hover:text-white">
                                    <?php echo e(translate('Setting')); ?>

                                </a>
                            </li>
                        <?php endif; ?>
                    </ul>
                    <?php if($isInstructor): ?>
                        <a href="<?php echo e(route('instructor.logout')); ?>"
                            class="flex font-medium px-4 py-2 text-sm text-gray-700 dark:text-dark-text hover:bg-gray-200 dark:hover:bg-dark-icon dark:hover:text-white"
                            onclick="event.preventDefault();
                            document.getElementById('header-logout-form').submit();">
                            <?php echo e(translate('Log out')); ?>

                        </a>
                        <form id="header-logout-form" action="<?php echo e(route('instructor.logout')); ?>" method="POST"
                            class="hidden">
                            <?php echo csrf_field(); ?>
                        </form>
                    <?php endif; ?>
                    <?php if($isStudent): ?>
                        <a href="<?php echo e(route('student.logout')); ?>"
                            class="flex font-medium px-4 py-2 text-sm text-gray-700 dark:text-dark-text hover:bg-gray-200 dark:hover:bg-dark-icon dark:hover:text-white"
                            onclick="event.preventDefault();
                            document.getElementById('header-logout-form').submit();">
                            <?php echo e(translate('Log out')); ?>

                        </a>
                        <form id="header-logout-form" action="<?php echo e(route('student.logout')); ?>" method="POST"
                            class="hidden">
                            <?php echo csrf_field(); ?>
                        </form>
                    <?php endif; ?>
                    <?php if($isOrganization): ?>
                        <a href="<?php echo e(route('organization.logout')); ?>"
                            class="flex font-medium px-4 py-2 text-sm text-gray-700 dark:text-dark-text hover:bg-gray-200 dark:hover:bg-dark-icon dark:hover:text-white"
                            onclick="event.preventDefault();
                            document.getElementById('header-logout-form').submit();">
                            <?php echo e(translate('Log out')); ?>

                        </a>
                        <form id="header-logout-form" action="<?php echo e(route('organization.logout')); ?>" method="POST"
                            class="hidden">
                            <?php echo csrf_field(); ?>
                        </form>
                    <?php endif; ?>

                    <?php if($isAdmin): ?>
                        <a href="<?php echo e(route('admin.logout')); ?>"
                            class="flex font-medium px-4 py-2 text-sm text-gray-700 dark:text-dark-text hover:bg-gray-200 dark:hover:bg-dark-icon dark:hover:text-white"
                            onclick="event.preventDefault();
                    document.getElementById('header-logout-form').submit();">
                            <?php echo e(translate('Log out')); ?>

                        </a>
                        <form id="header-logout-form" action="<?php echo e(route('admin.logout')); ?>" method="POST"
                            class="hidden">
                            <?php echo csrf_field(); ?>
                        </form>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</header>
<!-- End Header -->
<?php /**PATH D:\www\edulab\Modules\LMS\resources\views\portals\components\admin\header.blade.php ENDPATH**/ ?>