<form action="<?php echo e($action); ?>" method="post" class="form" enctype="multipart/form-data">
    <?php echo csrf_field(); ?>
    <div class="card grid grid-cols-2 gap-x-4 gap-y-6">
        <div class="col-span-full xl:col-auto leading-none">
            <label class="form-label"> <?php echo e(translate('Title')); ?> <span class="text-danger">*</span></label>
            <input type="text" placeholder="<?php echo e(translate('Enter your Title')); ?>" name="title" class="form-input"
                autocomplete="off">
            <span class="text-danger error-text title_err"></span>
        </div>
        <div class="col-span-full xl:col-auto leading-none">
            <label for="noticeType" class="form-label"> <?php echo e(translate('Support Type')); ?> <span
                    class="text-danger">*</span></label>
            <select class="singleSelect support-category-type" name="type" required>
                <option selected disabled> <?php echo e(translate('Select Course Type')); ?> </option>
                <option value="platform"> <?php echo e(translate('Platform')); ?> </option>
                <option value="course"> <?php echo e(translate('Course')); ?> </option>
            </select>
            <span class="text-danger error-text type_err"></span>
        </div>
        <div class="col-span-full xl:col-auto leading-none" id="supportCourse">
            <label for="noticeType" class="form-label"> <?php echo e(translate('Course')); ?> <span
                    class="text-danger">*</span></label>
            <select class="singleSelect" name="course_id" required>
                <option selected disabled> <?php echo e(translate('Select Course Type')); ?> </option>
                <?php if(isStudent()): ?>
                    <?php $__currentLoopData = purchase_enrolled_courses(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $purchaseCourse): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $courseTranslations = parse_translation($purchaseCourse?->course);
                        ?>
                        <option value="<?php echo e($purchaseCourse?->course?->id); ?>">
                            <?php echo e($courseTranslations['title'] ?? $purchaseCourse?->course?->title); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php else: ?>
                    <?php if(isset($courses)): ?>
                        <?php $__currentLoopData = $courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $courseTranslations = parse_translation($course);
                            ?>
                            <option value="<?php echo e($course?->id); ?>">
                                <?php echo e($courseTranslations['title'] ?? $course?->title); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>
                <?php endif; ?>

            </select>
            <span class="text-danger error-text course_id_err"></span>
        </div>
        <div class="col-span-full xl:col-auto leading-none" id="supportCategory">
            <label for="noticeType" class="form-label"> <?php echo e(translate('Support Category')); ?> <span
                    class="text-danger">*</span></label>
            <select class="singleSelect" name="support_category_id" required>
                <option selected disabled> <?php echo e(translate('Select Support Category')); ?> </option>
                <?php $__currentLoopData = supportCategories(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $supportCategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                        $categoryTranslations = parse_translation($supportCategory);
                    ?>
                    <option value="<?php echo e($supportCategory?->id); ?>">
                        <?php echo e($categoryTranslations['name'] ?? $supportCategory?->name); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
            <span class="text-danger error-text support_category_id_err"></span>
        </div>
        <div class="col-span-full">
            <label for="courseType" class="form-label"> <?php echo e(translate('Description')); ?> <span
                    class="text-danger">*</span> </label>
            <textarea class="summernote" name="description"></textarea>
            <span class="text-danger error-text description_err"></span>
        </div>
        <div class="">

            <label for="attatch-support-file"
                class="file-container file-input-label !dk-border-two bg-transparent text-[#727175] h-11 w-max dk-theme-card-square">
                <span
                    class="px-3 rounded-lg rounded-r-none border-r bg-[#EEEEEE] dark:bg-dark-icon border-input-border dark:border-dark-border-four flex-center before:font-remix before:text-xl text-sm before:content-['\f24e'] dark:before:text-dark-text-two dk-theme-card-square"></span>
                <input type="file" name="support_files[]" id="attatch-support-file" class="hidden file-src" multiple>
                <span class="file-name text-sm p-2.5"> <?php echo e(translate('No file choose')); ?> </span>
            </label>
        </div>
    </div>
    <div class="card flex justify-end">
        <button type="submit" class="btn b-solid btn-primary-solid px-5 dk-theme-card-square">
            <?php echo e(isset($notice) ? translate('Update') : translate('Save')); ?>

        </button>
    </div>
</form>
<?php /**PATH D:\www\edulab\Modules\LMS\resources\views\portals\components\supports\create.blade.php ENDPATH**/ ?>