<div id="course-curriculumn" class="tabcontent hidden">
    <h3 class="lg:text-32 sm:text-28 text-xl font-semibold text-heading mb-4">
        <?php echo e(translate('Course Curriculum')); ?>

    </h3>
    <div class="space-y-5">
        <?php $__currentLoopData = $course->chapters; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $chapter): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="border border-gray-200 rounded-md">
                <div class="accordion course-over-accord group/courseAccord">
                    <h5 class="font-medium text-heading grow">
                        <?php echo e($chapter->title); ?>

                    </h5>
                    <h6 class="text-gray shrink-0"> 
                        <?php echo e(translate('Lesson')); ?>:
                        <strong><?php echo e($chapter?->topics?->count()); ?></strong>
                    </h6>
                </div>
                <div class="accordionpanel panel">
                    <?php $__currentLoopData = $chapter->topics; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $topic): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if($topic?->topicable?->topic_type?->slug == 'video'): ?>
                            <a href="<?php echo e(authCheck() ? route('play.course', $course->slug . '?type=' . $topic?->topicable?->topic_type?->slug . '&item=' . $topic->id) : '#'); ?>" class="course-accord-item gap-5 hover:bg-slate-100 group/curriculum" aria-label="Course curriculum">
                                <div class="flex items-center gap-2 font-medium group-hover/curriculum:text-primary duration-200 grow">
                                    <i class="ri-file-video-line"></i>
                                    <span class="-mb-1 line-clamp-1"><?php echo e($topic?->topicable?->title); ?></span>
                                </div>
                                <div class="text-primary text-sm flex items-center justify-center gap-4 shrink-0"><?php echo e(translate('Video')); ?>: <?php echo e($topic?->topicable?->duration); ?></div>
                            </a>
                        <?php endif; ?>

                        <?php if($topic?->topicable?->topic_type?->slug == 'reading'): ?>
                            <a href="<?php echo e(authCheck() ? route('play.course', $course->slug . '?type=' . $topic?->topicable?->topic_type?->slug . '&item=' . $topic->id) : '#'); ?>" class="course-accord-item gap-5 hover:bg-slate-100 group/curriculum" aria-label="Course curriculum">
                                <div class="flex items-center gap-2 font-medium group-hover/curriculum:text-primary duration-200 grow">
                                    <i class="ri-file-text-line"></i>
                                    <span class="-mb-1 line-clamp-1"><?php echo e($topic?->topicable?->title); ?></span>
                                </div>
                                <div class="text-primary text-sm flex items-center justify-center gap-4 shrink-0"><?php echo e(translate('Read')); ?></div>
                            </a>
                        <?php endif; ?>

                        <?php if($topic?->topicable?->topic_type?->slug == 'supplement'): ?>
                            <a href="<?php echo e(authCheck() ? route('play.course', $course->slug . '?type=' . $topic?->topicable?->topic_type?->slug . '&item=' . $topic->id) : '#'); ?>" class="course-accord-item gap-5 hover:bg-slate-100 group/curriculum" aria-label="Course curriculum">
                                <div class="flex items-center gap-2 font-medium group-hover/curriculum:text-primary duration-200 grow">
                                    <i class="ri-file-text-line"></i>
                                    <span class="-mb-1 line-clamp-1"><?php echo e($topic?->topicable?->title); ?></span>
                                </div>
                                <div class="text-primary text-sm flex items-center justify-center gap-4 shrink-0"><?php echo e(translate('Read')); ?></div>
                            </a>
                        <?php endif; ?>

                        <?php if($topic?->topicable?->topic_type?->slug == 'assignment'): ?>
                            <a href="<?php echo e(authCheck() ? route('play.course', $course->slug . '?type=' . $topic?->topicable?->topic_type?->slug . '&item=' . $topic->id) : '#'); ?>" class="course-accord-item gap-5 hover:bg-slate-100 group/curriculum" aria-label="Course curriculum">
                                <div class="flex items-center gap-2 font-medium group-hover/curriculum:text-primary duration-200 grow">
                                    <i class="ri-a-b"></i>
                                    <span class="-mb-1 line-clamp-1"><?php echo e($topic?->topicable?->title); ?></span>
                                </div>
                                <div class="text-primary text-sm flex items-center justify-center gap-4 shrink-0"><?php echo e(translate('Assignment')); ?></div>
                            </a>
                        <?php endif; ?>

                        <?php if($topic?->topicable?->topic_type?->slug == 'quiz'): ?>
                            <a href="<?php echo e(authCheck() ? route('play.course', $course->slug . '?type=' . $topic?->topicable?->topic_type?->slug . '&item=' . $topic->id) : '#'); ?>" class="course-accord-item gap-5 hover:bg-slate-100 group/curriculum" aria-label="Course curriculum">
                                <div class="flex items-center gap-2 font-medium group-hover/curriculum:text-primary duration-200 grow">
                                    <i class="ri-questionnaire-line"></i>
                                    <span class="-mb-1 line-clamp-1"><?php echo e($topic?->topicable?->title); ?></span>
                                </div>
                                <div class="text-primary text-sm flex items-center justify-center gap-4 shrink-0"><?php echo e(translate('Quiz')); ?></div>
                            </a>
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
</div><?php /**PATH D:\www\edulab\Modules\LMS\resources\views\components\frontend\course\details\course-curriculumn.blade.php ENDPATH**/ ?>