<?php

namespace Modules\LMS\Database\Seeders;

use Illuminate\Database\Seeder;

use Modules\LMS\Models\Page;

class PageSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $pages =
            [
                [
                    'title' => 'Privacy Policy',
                    'url' => 'privacy-policy',
                    'content' => '<div><span>﻿</span>At Edulab LMS Website, we are committed to protecting your privacy and ensuring a safe online experience. This Privacy Policy explains how we collect, use, and safeguard your personal information when you visit or use our website, <a href="https://edulab.codexshaper.com/">https://edulab.codexshaper.com/</a>. By using our Website, you agree to the terms of this Privacy Policy.</div><div><br></div><div><br></div><div><h3><b><span style="font-size:18px;">1. Information We Collect</span></b></h3></div><div>We collect the following types of information when you use our Website:</div><div><br></div><div><br></div><div><h2><b><span style="font-size:18px;">Personal Information</span></b></h2></div><div>When you create an account, purchase a course, or interact with our Services, we may collect the following personal information:</div><div><br></div><div>&nbsp; &nbsp; Name</div><div>&nbsp; &nbsp; Email address</div><div>&nbsp; &nbsp; Billing address</div><div>&nbsp; &nbsp; Payment information (processed through third-party payment providers)</div><div>&nbsp; &nbsp; Profile details (such as photo, bio, etc.)</div><div>&nbsp; &nbsp; b. Non-Personal Information</div><div><br></div><div>We may collect non-personal information about how you use the Website, including but not limited to:</div><div><br></div><div>IP address</div><div><br></div><div>Browser type</div><div><br></div><div>Device information</div><div><br></div><div>Usage data (such as pages visited, time spent, and links clicked)</div><div><br></div><div><h2><b><span style="font-size:18px;">2. How We Use Your Information</span></b></h2></div><div>We use your information for the following purposes:</div><div><br></div><div>Account Management: To create and manage your account, and provide customer support.</div><div><br></div><div>Course Access: To grant access to purchased or enrolled courses and track your progress.</div><div><br></div><div>Communication: To send you updates, newsletters, promotional offers, and customer support messages.</div><div><br></div><div>Payment Processing: To process payments for courses or subscriptions. We use third-party payment processors for secure transactions.</div><div><br></div><div>Analytics: To analyze usage trends, improve our website, and enhance user experience.</div><div><br></div><div>Legal Compliance: To comply with applicable laws, regulations, and respond to legal requests.</div><div><br></div><div><br></div><div><h2><b><span style="font-size:18px;">3. How We Protect Your Information</span></b></h2></div><div>We take the protection of your information seriously. We implement a variety of security measures, including encryption and secure server practices, to protect your personal data from unauthorized access, alteration, disclosure, or destruction. However, no data transmission over the internet can be guaranteed to be 100% secure, and we cannot guarantee the absolute security of your information.</div><div><br></div><div><br></div><div><h2><b><span style="font-size:18px;">4. Cookies and Tracking Technologies</span></b></h2></div><div>Our Website uses cookies and similar technologies to improve user experience, analyze usage patterns, and provide personalized content. Cookies are small data files stored on your device. You can manage or disable cookies through your browser settings, but please note that some features of the Website may not function properly if cookies are disabled.</div><div><br></div><div>We may use third-party services, such as Google Analytics, to collect data on your usage of the Website. These services use cookies to gather and analyze data, which helps us improve the Website.</div><div><br></div><div><h2><b><span style="font-size:18px;">5. Sharing Your Information</span></b></h2></div><div>We do not sell, rent, or trade your personal information. However, we may share your information in the following situations:</div><div><br></div><div>Service Providers: We may share your information with third-party service providers who assist us in operating the Website, processing payments, and delivering our services (e.g., payment processors, hosting providers).</div><div><br></div><div>Legal Compliance: We may disclose your information if required by law or to comply with legal processes, such as subpoenas or court orders.</div><div><br></div><div>Business Transfers: If we are involved in a merger, acquisition, or sale of assets, your information may be transferred as part of that transaction.</div><div><br></div><div><br></div><div><h2><b><span style="font-size:18px;">6. Your Choices and Rights</span></b></h2></div><div>You have the following rights regarding your personal information:</div><div><br></div><div>Access and Correction: You can review and update your account information at any time through your account settings.</div><div><br></div><div>Deletion: You can request to delete your account and personal information by contacting us. Please note that some data may be retained for legal or administrative purposes.</div><div><br></div><div>Opt-Out of Communications: You can opt out of receiving promotional emails by following the unsubscribe link in the email or by contacting us directly. However, we may still send you transactional emails related to your account or course updates.</div><div><br></div><div><br></div><div><h2><b><span style="font-size:18px;">7. Children’s Privacy</span></b></h2></div><div>Our Website is not intended for use by individuals under the age of [Insert Age, typically 13 or older], and we do not knowingly collect personal information from children. If we learn that we have inadvertently collected personal information from a child under the age of [Insert Age], we will take steps to delete the information as soon as possible.</div><div><br></div><div><br></div><div><h2><b><span style="font-size:18px;">8. Third-Party Links</span></b></h2></div><div>The Website may contain links to third-party websites or services. This Privacy Policy applies only to our Website and does not cover third-party sites. We encourage you to review the privacy policies of any third-party sites before providing them with your personal information.</div><div><br></div><div><h2><b><span style="font-size:18px;">9. Changes to This Privacy Policy</span></b></h2></div><div>We may update this Privacy Policy from time to time. When we make changes, we will update the "Effective Da</div>'
                ],
                [
                    'title' => 'Terms & Condition',
                    'url' => 'terms-conditions',
                    'content' => '<p><br></p><p><span style="font-size:24px;"><b>Welcome to Edulab LMS Website</b></span></p><p><span><b><br></b></span></p><p>These Terms and Conditions ("Terms") govern your access to and use of the website <a href="https://edulab.codexshaper.com/">https://edulab.codexshaper.com/</a>, including all content, services, and features offered on or through the Website (the "Services"). By accessing or using the Website, you agree to comply with and be bound by these Terms. If you do not agree to these Terms, please do not use the Website.</p><p><br></p><p><b><span style="font-size:18px;">1. User Eligibility</span></b></p><p>You must be at least [insert age] years old to use our Website. By using the Website, you represent and warrant that you meet the eligibility requirements.</p><p><br></p><p><b><span style="font-size:18px;">2. Account Registration</span></b></p><p>To access certain Services, you may be required to create an account by providing accurate and up-to-date information. You are responsible for maintaining the confidentiality of your account credentials and for all activities that occur under your account. Notify us immediately if you believe your account has been compromised.</p><p><br></p><p><b><span style="font-size:18px;">3. Use of the Website</span></b></p><p>You agree to use the Website solely for lawful purposes and in accordance with these Terms. You must not:</p><p><br></p><p>Violate any applicable local, state, national, or international law.</p><p>Upload, post, or transmit any content that is unlawful, harmful, or infringing.</p><p>Engage in any activity that could disable, overload, or damage the functionality of the Website.</p><p><br></p><p><b><span style="font-size:18px;">4. Intellectual Property</span></b></p><p>All content, including but not limited to text, images, videos, courses, software, and other materials available on the Website, are owned by or licensed to [Your LMS Website Name] and are protected by intellectual property laws. You may not reproduce, distribute, or create derivative works from any content without prior written consent from the owner.</p><p><br></p><p><b><span style="font-size:18px;">5. Content Submission</span></b></p><p>If you submit any content (such as course materials, comments, or feedback) through the Website, you grant Edulab a worldwide, royalty-free, and irrevocable license to use, reproduce, modify, and distribute that content in connection with the Website and its Services.</p><p><br></p><p><b><span style="font-size:18px;">6. Course Access and Use</span></b></p><p>Access to courses, content, and materials on the Website is subject to the specific terms outlined in the course description or agreement. We reserve the right to update, modify, or remove any course content at any time. Course access may be revoked if you violate these Terms.</p><p><br></p><p><b><span style="font-size:18px;">7. Payment and Refund Policy</span></b></p><p>If you purchase a course or subscription, you agree to pay all applicable fees. Payments are processed through third-party payment processors, and you are responsible for providing accurate billing information. Please refer to our [Refund Policy] for details regarding cancellations or refunds.</p><p><br></p><p><b><span style="font-size:18px;">8. Privacy and Data Collection</span></b></p><p>Your use of the Website is also governed by our Privacy Policy, which outlines how we collect, use, and protect your personal information. By using the Website, you consent to the collection and use of your data as described in the Privacy Policy.</p><p><br></p><p><b><span style="font-size:18px;">9. Disclaimers</span></b></p><p>The Website and its Services are provided "as is" and "as available." We do not make any warranties or representations regarding the accuracy, completeness, or availability of the Website or its content. We are not responsible for any loss or damage arising from your use of the Website.</p><p><br></p><p><b><span style="font-size:18px;">10. Limitation of Liability</span></b></p><p>To the fullest extent permitted by law, [Your LMS Website Name] and its affiliates will not be liable for any indirect, incidental, special, consequential, or punitive damages, including but not limited to loss of profits, arising out of or related to these Terms, the use of the Website, or the Services.</p><p><br></p><p><b><span style="font-size:18px;">11. Termination</span></b></p><p>We reserve the right to suspend or terminate your account and access to the Website at any time, for any reason, including for violating these Terms. Upon termination, you must cease all use of the Website and its Services.</p><p><br></p><p><b><span style="font-size:18px;">12. Amendments</span></b></p><p>We may update or modify these Terms at any time, and the updated Terms will be posted on this page with a new effective date. Your continued use of the Website after any changes constitutes your acceptance of the revised Terms.</p><p><br></p><p><b><span style="font-size:18px;">13. Governing Law</span></b></p><p>These Terms shall be governed by and construed in accordance with the laws of [Your Jurisdiction], without regard to its conflict of laws principles. Any disputes arising from or related to these Terms shall be resolved in the courts located in [Your Jurisdiction].</p><p><br></p><p><b><span style="font-size:18px;">14. Contact Information</span></b></p><p>If you have any questions about these Terms, please contact us at:</p><p><br></p><p>Email: edulab@gmail.com</p><p>Address: P8MH+9A New York, USA</p><p>Disclaimer: This template is a general guide and should not be used as a substitute for legal advice. Please consult with a lawyer to ensure that the Terms and Conditions fully meet the specific needs of your LMS website and comply with applicable laws.</p>'
                ]
            ];

        foreach ($pages as $page) {
            Page::updateOrCreate(['url' => $page['url']], $page);
        }
    }
}
