<?php
    $instructors = $instructors ?? [];
    $totalInstructors = count($instructors);

    $instructorRoute = '';
    $instructorBtnText = '';

    if ($totalInstructors > 0) {
        $instructorRoute = route('instructor.list');
        $instructorBtnText = 'More Instructors';
    }

    if (isAdmin() && $totalInstructors < 1) {
        $instructorRoute = route('instructor.create');
        $instructorBtnText = 'Add Instructor';
    }
?>

<div class="bg-white py-16 sm:py-24 lg:py-[120px]">
    <div class="container">
        <!-- HEADER -->
        <div class="grid grid-cols-12 gap-4 items-center">
            <div class="col-span-full md:col-span-7 xl:col-span-6 md:pr-20">
                <div class="area-subtitle">
                    <?php echo e(translate('Our Team Member')); ?>

                </div>
                <h2 class="area-title mt-2">
                    <?php echo e(translate('Meet Our Best')); ?>

                    <span class="title-highlight-one"> <?php echo e(translate('Instructors')); ?> </span>
                </h2>
            </div>
            <?php if($instructorRoute && $instructorBtnText): ?>
                <div class="col-span-full md:col-span-5 xl:col-span-6 md:justify-self-end">
                    <a href="<?php echo e($instructorRoute); ?>" title="<?php echo e($instructorBtnText); ?>"
                        class="btn b-solid btn-primary-solid btn-xl !rounded-full font-medium text-[16px] md:text-[18px]"
                        aria-label="<?php echo e($instructorBtnText); ?>">
                        <?php echo e(translate($instructorBtnText)); ?>

                        <span class="hidden md:block">
                            <i class="ri-arrow-right-up-line text-[20px] rtl:before:content-['\ea66']"></i>
                        </span>
                    </a>
                </div>
            <?php endif; ?>
        </div>
        <!-- BODY -->
        <div class="swiper instructor-slider mt-10 lg:mt-[60px]">
            <div class="swiper-wrapper">
                <!-- SINGLE INSTRUCTOR -->
                <?php $__currentLoopData = $instructors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $instructor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if (isset($component)) { $__componentOriginalaf007c0b6a24ad0b4c891d7ffd003551 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalaf007c0b6a24ad0b4c891d7ffd003551 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'f484570d7cf557020e11ace406901b10::cards.instructor-card-one','data' => ['instructor' => $instructor]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('theme::cards.instructor-card-one'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['instructor' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($instructor)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalaf007c0b6a24ad0b4c891d7ffd003551)): ?>
<?php $attributes = $__attributesOriginalaf007c0b6a24ad0b4c891d7ffd003551; ?>
<?php unset($__attributesOriginalaf007c0b6a24ad0b4c891d7ffd003551); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalaf007c0b6a24ad0b4c891d7ffd003551)): ?>
<?php $component = $__componentOriginalaf007c0b6a24ad0b4c891d7ffd003551; ?>
<?php unset($__componentOriginalaf007c0b6a24ad0b4c891d7ffd003551); ?>
<?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>
</div>
<?php /**PATH D:\www\edulab\Modules\LMS\resources\views\components\instructor\top-instructor.blade.php ENDPATH**/ ?>