<?php

    $isOrganization = isOrganization();
    $isAdmin = isAdmin();
    $isInstructor = isInstructor();
    $currentUser = authCheck();

    $locale = request()->locale ?? app()->getLocale();
    $translations = [];
    $course = $course ?? null;
    if ($course && $locale) {
        $translations = parse_translation($course, $locale);
    }
    $type = $type ?? '';
?>

<!-- Start Basic -->
<div class="fieldset !block">
    <form action="<?php echo e($action ?? '#'); ?>" method="POST" data-key="basic" enctype="multipart/form-data">
        <?php echo csrf_field(); ?>
        <input type="hidden" name="course_id" class="courseId" value="<?php echo e($course->id ?? ''); ?>">
        <input type="hidden" name="locale" class="form-input" value="<?php echo e($locale ?? ''); ?>">
        <div class="grid grid-cols-12 gap-x-4">
            <!-- LEFT AREA -->
            <div class="col-span-full lg:col-span-6 card">
                <div class="leading-none">
                    <label for="courseTitle" class="form-label">
                        <?php echo e(translate('How about a course title')); ?>

                        <span class="text-danger" title="<?php echo e(translate('This field is required')); ?>"><b>*</b></span>
                    </label>
                    <input type="text" name="title" value="<?php echo e($translations['title'] ?? ($course->title ?? '')); ?>"
                        placeholder="<?php echo e(translate('Course Title')); ?>" class="form-input">
                    <span class="text-danger error-text title_err"></span>
                </div>

                <div class="leading-none mt-6">
                    <label for="courseCategory" class="form-label">
                        <?php echo e(translate('Courses category')); ?>

                        <span class="text-danger" title="<?php echo e(translate('This field is required')); ?>"><b>*</b></span>
                    </label>
                    <select name="category_id" id="courseCategory"
                        class="list-border-primary px-5 py-[17.5px] wide leading-none border border-input-border rounded-10 text-gray-900 font-spline_sans [&.open]:border-primary-400">
                        <option></option>
                        <?php $__currentLoopData = get_all_category(locale: $locale); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php $categoryTranslations = parse_translation($category, $locale); ?>
                            <option value="<?php echo e($category->id); ?>"
                                <?php echo e(isset($course) && $course->category_id == $category->id ? 'selected' : ''); ?>>
                                <?php echo e($categoryTranslations['title'] ?? ($category->title ?? '')); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <span class="text-danger error-text category_id_err"></span>
                </div>
                <?php if(!$isOrganization): ?>
                    <div class="leading-none mt-6">
                        <label for="courseInstructor" class="form-label"> <?php echo e(translate('Organization')); ?> </label>
                        <select
                            class="js-example-basic-single form-input px-5 py-4 rounded-10  <?php echo e($isAdmin || $isOrganization ? 'organization-list' : ''); ?> "
                            name="organization_id" data-locale="<?php echo e($locale); ?>">
                            <option value="no-select"> <?php echo e(translate('Select Organization')); ?> </option>
                            <?php $__currentLoopData = get_all_organization(locale: $locale); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $organization): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $orgUser = $organization?->userable;
                                    $orgTranslations = parse_translation($orgUser, $locale);
                                ?>
                                <option value="<?php echo e($organization->id); ?>"
                                    <?php echo e(isset($course) && $course->organization_id == $organization->id ? 'selected' : ''); ?>>
                                    <?php echo e($orgTranslations['name'] ?? $orgUser?->name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                <?php endif; ?>
                <?php if($isAdmin || $isOrganization): ?>
                    <div class="leading-none mt-6">
                        <label class="form-label">
                            <?php echo e(translate('Instructor')); ?>

                            <span class="text-danger" title="<?php echo e(translate('This field is required')); ?>"><b>*</b></span>
                        </label>
                        <select class="js-example-basic-single" name="instructors[]" id="instructorOption" multiple>
                            <option disabled><?php echo e(translate('Select Instructor')); ?></option>

                            <?php $__currentLoopData = get_all_instructor($currentUser->id ?? null, locale: $locale); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $instructor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $insUser = $instructor?->userable;
                                    $userTranslations = parse_translation($insUser, $locale);
                                ?>
                                <option value="<?php echo e($instructor->id); ?>"
                                    <?php if(isset($course, $course->instructors) && !empty($course->instructors)): ?> <?php $__currentLoopData = $course->instructors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cinstructor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                             <?php echo e($cinstructor->id == $instructor->id ? 'selected' : ''); ?>

                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <?php endif; ?>>
                                    <?php echo e($userTranslations['first_name'] ?? $insUser?->first_name); ?>

                                    <?php echo e($userTranslations['last_name'] ?? $insUser?->last_name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <span class="text-danger error-text instructors_err"></span>
                    </div>
                <?php endif; ?>
                <?php if($isInstructor): ?>
                    <input type="hidden" name="instructors[]" value="<?php echo e($currentUser->id); ?>">
                <?php endif; ?>
                <?php if($isOrganization): ?>
                    <input type="hidden" name="organization_id" value="<?php echo e($currentUser->id); ?>">
                <?php endif; ?>
                <div class="leading-none mt-6">
                    <label for="courseLevel" class="form-label">
                        <?php echo e(translate('Courses level')); ?>

                        <span class="text-danger" title="<?php echo e(translate('This field is required')); ?>"><b>*</b></span>
                    </label>
                    <select name="levels[]" multiple="true" id="courseLevel"
                        class="level-list list-border-primary px-5 py-[17.5px] wide leading-none border border-input-border rounded-10 text-gray-900 font-spline_sans [&.open]:border-primary-400">
                        <?php $__currentLoopData = get_all_level(locale: $locale); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $level): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php $levelTranslations = parse_translation($level, $locale); ?>
                            <option value="<?php echo e($level->id); ?>"
                                <?php if(isset($course, $course->levels) && !empty($course->levels)): ?> <?php $__currentLoopData = $course->levels; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $clevel): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php echo e($clevel->id == $level->id ? 'selected' : ''); ?> <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <?php endif; ?>>
                                <?php echo e($levelTranslations['name'] ?? ($level->name ?? '')); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>

                    <span class="text-danger error-text levels_err"></span>
                </div>
                <?php
                    $src_type = $course->video_src_type ?? null;
                ?>
                <div class="leading-none mt-6">
                    <label class="form-label">
                        <?php echo e(translate('Course Demo Video Source')); ?>

                        <span class="text-danger" title="<?php echo e(translate('This field is required')); ?>"><b>*</b></span>
                    </label>
                    <select class="singleSelect" name="video_src_type" id="source-type-select">
                        <option disabled selected><?php echo e(translate('Select Source Type')); ?></option>
                        <option value="youtube" <?php echo e($src_type == 'youtube' ? 'selected' : ''); ?>>
                            <?php echo e(translate('Youtube')); ?></option>
                        <option value="vimeo" <?php echo e($src_type == 'vimeo' ? 'selected' : ''); ?>><?php echo e(translate('Vimeo')); ?>

                        </option>
                        <option value="local" <?php echo e($src_type == 'local' ? 'selected' : ''); ?>><?php echo e(translate('Local')); ?>

                        </option>
                    </select>
                    <span class="text-danger error-text video_src_type_err"></span>
                    <div id="courseVideoFile" class="mt-4">
                        <?php if(isset($course, $src_type) && $src_type !== 'local'): ?>
                            <label class="form-label">
                                <?php echo e(translate('Video url')); ?>

                                <span class="text-danger"
                                    title="<?php echo e(translate('This field is required')); ?>"><b>*</b></span>
                            </label>
                            <input type="url" class="form-input" placeholder="<?php echo e(translate('Video url')); ?>"
                                value="<?php echo e($course->demo_url ?? ''); ?>" name="demo_url" autocomplete="off" />
                        <?php elseif(isset($course) && $src_type == 'local'): ?>
                            <label class="form-label">
                                <?php echo e(translate('Upload File')); ?>

                                <span class="text-danger"
                                    title="<?php echo e(translate('This field is required')); ?>"><b>*</b></span>
                            </label>
                            <div class="border border-input-border rounded-md px-2 py-1.5">
                                <input type="file" class="w-full" name="short_video">
                            </div>
                            <span class="text-danger error-text short_video_err"></span>
                            <?php if(isset($course)): ?>
                                <div class="video mt-4">
                                    <?php if(fileExists($folder = 'lms/courses/demo-videos', $fileName = $course->short_video) == true &&
                                            $course->short_video !== ''): ?>
                                        <video width="320" height="240" controls autoplay>
                                            <source
                                                src="<?php echo e(asset('storage/lms/courses/demo-videos/' . $course->short_video)); ?>">
                                        </video>
                                    <?php endif; ?>
                                </div>
                            <?php endif; ?>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="leading-none mt-6">
                    <label for="subject" class="form-label">
                        <?php echo e(translate('Subject')); ?>

                        <span class="text-danger" title="<?php echo e(translate('This field is required')); ?>"><b>*</b></span>
                    </label>
                    <select name="subject_id" id="subject"
                        class="singleSelect list-border-primary px-5 py-[17.5px] wide leading-none border border-input-border rounded-10 text-gray-900 font-spline_sans [&.open]:border-primary-400">
                        <option selected disabled><?php echo e(translate('Select subject')); ?></option>
                        <?php $__currentLoopData = get_all_subject(locale: $locale); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subject): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php $subjectTranslations = parse_translation($subject, $locale); ?>
                            <option value="<?php echo e($subject->id); ?>"
                                <?php echo e(isset($course) && $course->subject_id == $subject->id ? 'selected' : ''); ?>>
                                <?php echo e($subjectTranslations['name'] ?? ($subject->name ?? '')); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <span class="text-danger error-text subject_id_err"></span>
                </div>
            </div>
            <!-- RIGHT AREA -->
            <div class="col-span-full lg:col-span-6 card">

                <div class="leading-none">
                    <label for="courseLanguage" class="form-label">
                        <?php echo e(translate('Language')); ?>

                        <span class="text-danger" title="<?php echo e(translate('This field is required')); ?>"><b>*</b></span>
                    </label>
                    <select name="languages[]" multiple="true" id="courseLanguage"
                        class="language-list list-border-primary px-5 py-[17.5px] wide leading-none border border-input-border rounded-10 text-gray-900 font-spline_sans [&.open]:border-primary-400">
                        <?php $__currentLoopData = get_all_language(locale: $locale); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php $languageTranslations = parse_translation($language, $locale); ?>
                            <option value="<?php echo e($language->id); ?>"
                                <?php if(isset($course, $course->languages) && !empty($course->languages)): ?> <?php $__currentLoopData = $course->languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $clanguage): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php echo e($clanguage->id == $language->id ? 'selected' : ''); ?> <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <?php endif; ?>>
                                <?php echo e($languageTranslations['name'] ?? ($language->name ?? '')); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <span class="text-danger error-text languages_err"></span>
                </div>
                <div class="leading-none mt-6">
                    <label for="zone" class="form-label">
                        <?php echo e(translate('Time Zone')); ?>

                        <span class="text-danger" title="<?php echo e(translate('This field is required')); ?>"><b>*</b></span>
                    </label>
                    <select name="time_zone_id"
                        class="zone-list list-border-primary px-5 py-[17.5px] wide leading-none border border-input-border rounded-10 text-gray-900 font-spline_sans [&.open]:border-primary-400">
                        <option></option>
                        <?php $__currentLoopData = get_all_zones(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $zone): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($zone->id); ?>"
                                <?php echo e(isset($course) && $course->time_zone_id == $zone->id ? 'selected' : ''); ?>>
                                <?php echo e($zone->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <span class="text-danger error-text time_zone_id_err"></span>
                </div>
                <div class="leading-none mt-6">
                    <label for="courseDuration" class="form-label">
                        <?php echo e(translate('Course duration')); ?>

                        <span class="text-danger" title="<?php echo e(translate('This field is required')); ?>"><b>*</b></span>
                    </label>
                    <input type="text" id="courseDuration" name="duration" value="<?php echo e($course->duration ?? ''); ?>"
                        placeholder="<?php echo e(translate('Topic duration')); ?>" class="form-input">
                    <span class="text-danger error-text duration_err"></span>
                </div>

                <div class="leading-none mt-6">

                    <label for="courseDuration" class="form-label">
                        <?php echo e(translate('Short Description')); ?>

                        <span class="text-danger" title="<?php echo e(translate('This field is required')); ?>"><b>*</b></span>
                    </label>
                    <textarea name="short_description" class="form-input" rows="6"><?php echo e($translations['short_description'] ?? ($course->short_description ?? '')); ?></textarea>
                    <span class="text-xs text-danger inline-block mt-1"><strong><?php echo e(translate('Recommended')); ?>

                            :</strong>
                        <?php echo e(translate('Word between - 120 to 150')); ?></span>
                    <p class="text-danger error-text short_description_err"></p>
                </div>
            </div>
        </div>
        <div class="grid grid-cols-12 gap-x-4">
            <div class="col-span-full lg:col-span-<?php echo e(isset($course) ? '12' : '8'); ?> card">

                <label class="form-label">
                    <?php echo e(translate('Description')); ?>

                    <span class="text-danger" title="<?php echo e(translate('This field is required')); ?>"><b>*</b></span>
                </label>
                <textarea name="description" class="summernote"><?php echo clean($translations['description'] ?? ($course->description ?? '')); ?></textarea>
                <span class="text-danger error-text description_err"></span>
            </div>

            <?php if(!isset($course)): ?>
                <div class="col-span-full lg:col-span-4 card">
                    <p class="text-xs text-gray-500 dark:text-dark-text leading-none font-semibold mb-3">
                        <?php echo e(translate('Thumbnail')); ?>(300 x300 )
                        <span class="text-danger" title="<?php echo e(translate('This field is required')); ?>"><b>*</b></span>
                    </p>
                    <label for="thumbnail"
                        class="dropzone-wrappe file-container ac-bg text-xs leading-none font-semibold mb-3 cursor-pointer w-full h-[200px] flex flex-col items-center justify-center gap-2.5 border border-dashed border-gray-900 rounded-10 dk-theme-card-square">
                        <input type="file" hidden name="thumbnail" id="thumbnail"
                            class="dropzone dropzone-image img-src peer/file">

                        <span class="flex-center flex-col peer-[.uploaded]/file:hidden">
                            <img src="<?php echo e(asset('lms/assets/images/icons/upload-file.svg')); ?>" alt="file-icon"
                                class="size-8 lg:size-auto">
                            <div class="text-gray-500 dark:text-dark-text mt-2"> <?php echo e(translate('Choose file')); ?>

                            </div>
                        </span>
                    </label>
                    <div class="preview-zone dropzone-preview">
                        <div class="box box-solid">
                            <div class="box-body flex items-center gap-2 flex-wrap">
                                <?php if(isset($course) &&
                                        fileExists($folder = 'lms/courses/thumbnails', $fileName = $course?->thumbnail) == true &&
                                        $course?->thumbnail !== ''): ?>
                                    <div class="img-thumb-wrapper">
                                        <img class="img-thumb" width="100"
                                            src="<?php echo e(asset('storage/lms/courses/thumbnails/' . $course->thumbnail)); ?>" />
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <span class="text-danger error-text thumbnail_err"></span>
                </div>
            <?php endif; ?>

        </div>
        <div class="card flex-center gap-4 justify-end">
            <button type="button" class="next-form-btn btn b-solid btn-primary-solid dk-theme-card-square">
                <?php if($type == 'translations'): ?>
                    <?php echo e(translate('Save')); ?>

                <?php else: ?>
                    <?php echo e(!isset($course) ? translate('Save') : translate('Save & Continue')); ?>

                <?php endif; ?>
            </button>
        </div>
    </form>
</div>
<?php /**PATH D:\www\edulab\Modules\LMS\resources\views\portals\components\course\basic-form.blade.php ENDPATH**/ ?>