<?php
    $questionStore = 'quiz-question.store';
    $questionEdit = 'quiz-question.edit';
    $quizDelete = 'quiz-question.destroy';
    if (isInstructor()) {
        $questionStore = 'instructor.quiz-question.store';
        $questionEdit = 'instructor.quiz-question.edit';
        $questionDelete = 'instructor.quiz-question.destroy';
    } elseif (isOrganization()) {
        $questionStore = 'organization.quiz-question.store';
        $questionEdit = 'organization.quiz-question.edit';
        $questionDelete = 'organization.quiz-question.destroy';
    }
?>


<?php if($mode == 'edit'): ?>
    <div class="pb-4 border-b border-gray-200">
        <h6 class="leading-none text-lg font-semibold text-heading">
            <button type="button" aria-label="Edit quiz question"
                class="btn b-solid btn-sm btn-primary-solid view-question mt-3 shadow-md"
                data-id="<?php echo e($quizQuestion?->quiz_id); ?>">
                <i class="ri-arrow-left-s-line text-inherit"></i>
                <?php echo e(translate('Back')); ?>

            </button>
            <?php echo e(translate('Edit Question')); ?>

        </h6>
    </div>
    <form action="<?php echo e(route($questionStore)); ?>" class="flex flex-col gap-10 mt-6 form" method="POST">
        <?php echo csrf_field(); ?>
        <input type="hidden" name="id" value="<?php echo e($quizQuestion->id); ?>">
        <input type="hidden" name="quiz_id" value="<?php echo e($quizQuestion?->quiz_id); ?>">
        <div class="max-h-[80vh] overflow-auto">
            <div class="overflow-hidden">
                <div class="relative">
                    <label for="quiz-question" class="form-label"><?php echo e(translate('Question Title')); ?></label>
                    <textarea name="title" rows="1" id="searchInput" data-search-type="question"
                        class="form-input search-suggestion"> <?php echo $quizQuestion?->question?->name; ?> </textarea>
                    <div class="search-show"></div>
                    <span class="text-danger error-text title_err"></span>
                </div>
                <div class="mt-4">
                    <label for="quiz-grade" class="form-label"><?php echo e(translate('Quiz Mark')); ?></label>
                    <input type="number" name="mark" value="<?php echo $quizQuestion->mark; ?>" id="quiz-grade"
                        class="form-input"></input>
                    <span class="text-danger error-text mark_err"></span>
                </div>
                <div class="mt-4">
                    <label class="form-label"><?php echo e(translate('Quiz Type')); ?></label>
                    <select class="singleSelect2 quiz-type-list" name="question_type" required>
                        <option selected disabled><?php echo e(translate('Select quiz Question type')); ?></option>
                        <option value="multiple-choice"
                            <?php echo e($quizQuestion->question_type == \Modules\LMS\Enums\QuestionTypes::MULTIPLE ? 'selected' : ''); ?>>
                            <?php echo e(translate('Multiple choice')); ?>

                        </option>
                        <option value="single-choice"
                            <?php echo e($quizQuestion->question_type == \Modules\LMS\Enums\QuestionTypes::SINGLE ? 'selected' : ''); ?>>
                            <?php echo e(translate('Single choice')); ?>

                        </option>
                        <option value="fill-in-blank"
                            <?php echo e($quizQuestion->question_type == \Modules\LMS\Enums\QuestionTypes::FILL_IN_BLANK ? 'selected' : ''); ?>>
                            <?php echo e(translate('Fill in the blank')); ?>

                        </option>
                    </select>
                    <span class="text-danger error-text question_type_err"></span>
                </div>
                <div class="answer-list-area">
                    <?php if($quizQuestion->question_type == \Modules\LMS\Enums\QuestionTypes::FILL_IN_BLANK): ?>
                        <?php
                            $list = [];
                            foreach ($quizQuestion->questionAnswers as $questionAnswer) {
                                $list[] = $questionAnswer?->answer?->name;
                            }
                        ?>
                        <div class="mt-10 mb-11">
                            <label for="quiz-grade" class="form-label">
                                <?php echo e(translate('Select the word in your question you want to appear in blank')); ?>

                                (_______).
                            </label>
                            <input type="text" class="form-input choices-input" name="answers[]"
                                value="<?php echo e(implode(',', $list)); ?>">
                        </div>
                        <script>
                            var choiseInput = document.querySelectorAll(".choices-input");
                            choiseInput.forEach((input) => {
                                var example = new Choices(input, {
                                    removeItemButton: true,
                                    maxItemCount: 3,
                                    duplicateItemsAllowed: false,
                                    allowHTML: true,
                                    searchEnabled: true,
                                });
                            });
                        </script>
                    <?php else: ?>
                        <button type="button" aria-label="Add quiz answer option"
                            class="btn b-solid btn-primary-solid addQuizAns mt-3"
                            data-quiztype="<?php echo e($quizQuestion->question_type); ?>"> <?php echo e(translate('Add Answer')); ?>

                        </button>
                        <ul class="flex flex-col gap-2 mt-5 quiz-ans-container"
                            data-length="<?php echo e($quizQuestion?->questionAnswers?->count()); ?>">
                            <?php $__currentLoopData = $quizQuestion->questionAnswers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $questionAnswer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li class="border border-input-border rounded-lg p-2 removeable-parent">
                                    <div class="flex gap-2 relative">
                                        <textarea name="answers[<?php echo e($index); ?>][name]" placeholder="Option 1" id="searchInput" data-search-type="answer"
                                            class="form-input search-suggestion" rows="1"> <?php echo $questionAnswer?->answer?->name; ?></textarea>

                                        <button type="button" aria-label="Remove option button"
                                            class="btn b-outline btn-danger-outline btn-sm max-h-10 remove-parent-button">
                                            <i class="ri-close-line text-inherit text-[13px]"></i>
                                        </button>
                                        <div class="search-show"></div>
                                    </div>
                                    <div class="leading-none flex items-center gap-2 mt-2">
                                        <label for="corrects<?php echo e($index); ?>"
                                            class="inline-flex items-center cursor-pointer">
                                            <?php if($quizQuestion->question_type == \Modules\LMS\Enums\QuestionTypes::MULTIPLE): ?>
                                                <input type="checkbox" id="corrects<?php echo e($index); ?>"
                                                    name="answers[<?php echo e($index); ?>][correct]"
                                                    class="appearance-none peer"
                                                    <?php echo e($questionAnswer->correct == 1 ? 'checked' : ''); ?>>
                                                <div class="switcher switcher-primary-solid"></div>
                                            <?php else: ?>
                                                <input type="radio" id="corrects<?php echo e($index); ?>"
                                                    name="answers[<?php echo e($index); ?>][correct]"
                                                    class="radio radio-primary"
                                                    <?php echo e($questionAnswer->correct == 1 ? 'checked' : ''); ?>>
                                            <?php endif; ?>
                                        </label>
                                        <div class="text-gray-500 font-medium inline-block">
                                            <?php echo e(translate('Check if this is Correct')); ?>

                                        </div>
                                    </div>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <div class="flex-center">
            <button type="submit" aria-label="Update quiz"
                class="btn b-solid btn-primary-solid w-1/2"><?php echo e(translate('Update Quiz')); ?></button>
        </div>
    </form>
    <script src="<?php echo e(asset('lms/assets/js/vendor/select2.min.js')); ?> "></script>

    <script>
        //===================== quiz type list

        $(document).on('change', '.quiz-type-list', function() {

            let ansList = $(".answer-list-area").html("");
            let quizType = $(this).val();
            if (quizType == "multiple-choice" || quizType == 'single-choice') {
                $(ansList).html(`<div class="mt-10">
                    <button type="button" aria-label="Add quiz answer option" class="btn b-solid btn-primary-solid addQuizAns" data-quiztype="${quizType}"> <?php echo e(translate('Add Answer')); ?> </button>
                    <ul class="flex flex-col gap-2 mt-5 quiz-ans-container" data-length="1">
                        <li class="border border-input-border rounded-lg p-2 removeable-parent">
                            <div class="flex gap-2 relative">
                                <textarea name="answers[0][name]" placeholder=" <?php echo e(translate('Option')); ?> 1" id="searchInput" data-search-type="answer" class="form-input search-suggestion" rows="1"></textarea>

                                <button type="button"
                                    aria-label="Remove option button"
                                    class="btn b-outline btn-danger-outline btn-sm max-h-10 remove-parent-button">
                                    <i class="ri-close-line text-inherit text-[13px]"></i>
                                </button>
                                <div class="search-show"></div>
                            </div>
                            <div class="leading-none flex items-center gap-2 mt-2">
                                <label for="corrects1" class="inline-flex items-center cursor-pointer">
                                    ${ quizType == "multiple-choice" ? '<input type="checkbox" id="corrects1" name="answers[0][correct]" class="appearance-none peer"> <div class="switcher switcher-primary-solid"></div>' : '<input type="radio"   id="correntans1" name="answers[0][correct]" class="radio radio-primary">' }

                                </label>
                                <div class="text-gray-500 font-medium inline-block">
                                    <?php echo e(translate('Check if this is Correct')); ?>

                                </div>
                            </div>
                        </li>
                    </ul>
                </div>`)
            } else if (quizType == "fill-in-blank") {
                $(ansList).html(`
                <div class="mt-10 mb-11">
                    <label for="quiz-grade" class="form-label"> <?php echo e(translate('Select the word in your question you want to appear in blank')); ?> (_______).
                    </label>
                    <input type="text" class="form-input choices-input" name="answers[]" >
                </div>`)
                choicesInput()
            }
        })

        setTimeout(() => {
            $(".singleSelect2").select2({
                width: "100%",
            });
        }, 50);
    </script>
<?php else: ?>
    <div class="pb-4 border-b border-gray-200">
        <h6 class="leading-none text-lg font-semibold text-heading"><?php echo e(translate('Question')); ?></h6>
    </div>
    <ul class="*:leading-none *:p-3 *:rounded-10 *:border *:border-input-border space-y-5 mt-10" id="questionList">
        <?php if(isset($quizQuestions) && !empty($quizQuestions)): ?>
            <?php $__currentLoopData = $quizQuestions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $quizQuestion): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li class="flex-center-between cursor-move question-item" data-item-id="<?php echo e($quizQuestion->id); ?>">
                    <div class="flex items-center gap-2.5">
                        <div class="size-8 rounded-50 bg-primary-100 flex-center">
                            <i class="ri-question-mark text-[14px] text-inherit"></i>
                        </div>
                        <b><?php echo e(ucfirst($quizQuestion->question_type)); ?> :</b>
                        <h6 class="text-gray-500 text-lg font-medium">
                            <span class="text-gray-900 font-normal">
                                <?php echo e($quizQuestion?->question?->name); ?>

                        </h6>
                    </div>
                    <div class="flex items-center gap-1.5">
                        <!-- Edit Question -->
                        <button type="button" class="btn-icon size-8 btn-primary-icon-light edit-question"
                            data-action="<?php echo e(route($questionEdit, $quizQuestion->id)); ?>">
                            <i class="ri-pencil-fill text-inherit text-base"></i>
                        </button>
                        <!-- Delete Question -->
                        <button type="button" class="btn-icon btn-danger-icon-light size-8 delete-btn-cs"
                            aria-label="Delete option" data-action="<?php echo e(route($quizDelete, $quizQuestion->id)); ?>">
                            <i class="ri-close-line text-inherit text-base"></i>
                        </button>
                    </div>
                </li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php endif; ?>


    </ul>
    <script>
        new Sortable(questionList, {
            animation: 150,
            onSort: function(ui) {
                let item = $(ui.from).find('.question-item')
                let itemIds = [];
                $.each(item, function(key, val) {
                    let id = $(val).data('item-id');
                    itemIds.push(id);
                })
                let action = baseUrl + "/quizzes/quiz-question-sorted";
                $.ajax({
                    url: action,
                    method: 'GET',
                    data: {
                        itemIds: itemIds
                    },
                    dataType: "json",
                    success: function(data) {
                        Command: toastr["success"](`${data.data}`)
                    }
                });
            },
        });
    </script>
<?php endif; ?>
<?php /**PATH D:\www\edulab\Modules\LMS\resources\views\components\course\topic-type\question-list.blade.php ENDPATH**/ ?>