<div class="overflow-x-auto scrollbar-table">
    <table
        class="table-auto w-full whitespace-nowrap text-left text-gray-500 dark:text-dark-text font-medium leading-none">
        <thead class="text-primary-500">
            <tr>
                <th
                    class="px-3.5 py-4 bg-[#F2F4F9] dark:bg-dark-card-two first:rounded-l-lg last:rounded-r-lg first:dk-theme-card-square-left last:dk-theme-card-square-right">
                    <?php echo e(isset($userType) && $userType == 'student' && $type == 'course' ? translate('Contact') : translate('Ticket Id')); ?>

                </th>
                <th
                    class="px-3.5 py-4 bg-[#F2F4F9] dark:bg-dark-card-two first:rounded-l-lg last:rounded-r-lg first:dk-theme-card-square-left last:dk-theme-card-square-right">
                    <?php echo e(translate('Title')); ?> </th>
                <th
                    class="px-3.5 py-4 bg-[#F2F4F9] dark:bg-dark-card-two first:rounded-l-lg last:rounded-r-lg first:dk-theme-card-square-left last:dk-theme-card-square-right">
                    <?php echo e(translate('Ticket Date')); ?> </th>
                <th
                    class="px-3.5 py-4 bg-[#F2F4F9] dark:bg-dark-card-two first:rounded-l-lg last:rounded-r-lg first:dk-theme-card-square-left last:dk-theme-card-square-right">
                    <?php echo e(translate('Ticket Status')); ?> </th>
                <th
                    class="px-3.5 py-4 bg-[#F2F4F9] dark:bg-dark-card-two first:rounded-l-lg last:rounded-r-lg first:dk-theme-card-square-left last:dk-theme-card-square-right w-10">
                    <?php echo e(translate('Action')); ?> </th>
            </tr>
        </thead>
        <tbody class="divide-y divide-gray-200 dark:divide-dark-border-three">
            <?php $__currentLoopData = $tickets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ticket): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <?php if($type == 'course' && isset($userType) && $userType == 'student'): ?>
                        <td class="px-3.5 py-4">
                            <?php if(isset($ticket?->courseSupport?->course)): ?>
                                <?php $__currentLoopData = $ticket?->courseSupport?->course?->instructors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $instructor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $user = $instructor?->userable ?? null;
                                        $profileImg =
                                            $user->profile_img &&
                                            fileExists('lms/instructors', $user?->profile_img) == true
                                                ? asset("storage/lms/instructors/{$user->profile_img}")
                                                : asset('lms/assets/images/placeholder/profile.jpg');

                                        $userTranslations = parse_translation($user);

                                    ?>
                                    <a href="#" class="flex items-center gap-2">
                                        <div class="size-10 rounded-50 overflow-hidden dk-theme-card-square">
                                            <img src="<?php echo e($profileImg); ?>" alt="instructor"
                                                class="size-full object-cover">
                                        </div>
                                        <h6 class="text-heading">
                                            <?php echo e($userTranslations['first_name'] ?? ($user?->first_name ?? '')); ?>

                                            <?php echo e($userTranslations['last_name'] ?? ($user?->last_name ?? '')); ?>

                                        </h6>
                                    </a>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                        </td>
                    <?php else: ?>
                        <td class="px-3.5 py-4">
                            <h6 class="text-md leading-none">#<?php echo e($ticket->ticket_code); ?></h6>
                        </td>
                    <?php endif; ?>
                    <td class="px-3.5 py-4">
                        <h6 class="text-md leading-none"><a href="#"><?php echo e($ticket->title); ?></a></h6>
                    </td>
                    <td class="px-3.5 py-4">
                        <?php echo e(customDateFormate($ticket->updated_at, $format = 'y M d')); ?>

                    </td>
                    <td class="px-3.5 py-4">
                        <?php switch($ticket->status):
                            case ('pending'): ?>
                                <span class="badge b-solid badge-warning-solid capitalize">
                                    <?php echo e(translate($ticket->status)); ?>

                                </span>
                            <?php break; ?>

                            <?php case ('active'): ?>
                                <span class="badge b-solid badge-success-solid capitalize">
                                    <?php echo e(translate($ticket->status)); ?>

                                </span>
                            <?php break; ?>

                            <?php case ('close'): ?>
                                <span class="badge b-solid badge-danger-solid capitalize">
                                    <?php echo e(translate($ticket->status)); ?>

                                </span>
                            <?php break; ?>
                        <?php endswitch; ?>

                    </td>
                    <td class="px-3.5 py-4">
                        <div class="flex items-center gap-1">
                            <a href="<?php echo e(route($action, ['id' => $ticket->id, 'type' => $type])); ?>"
                                class="btn-icon btn-primary-icon-light size-8">
                                <i class="ri-<?php echo e($icon == 'reply' ? 'reply' : 'eye'); ?>-line text-inherit text-base"></i>
                            </a>
                        </div>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</div>
<?php /**PATH D:\www\edulab\Modules\LMS\resources\views\portals\components\supports\ticket-list.blade.php ENDPATH**/ ?>