<?php
    $counter = get_theme_option(key: 'counter') ?? [];
    $totalExperience = $counter['total_experience'] ?? 1;
    $totalCourse = get_all_course('approved')->count() ?? [];
    $totalCourseText = $totalCourse > 0 ? 'Course' : 'Courses';
    $totalTutor = get_all_instructor()->count() ?? [];
    $totalTutorText = $totalTutor > 1 ? 'Expert Tutors' : 'Expert Tutor';
    $totalStudent = get_all_student()->count() ?? [];
    $totalStudentText = $totalStudent > 1 ? 'Satisfied Students' : 'Satisfied Student';
?>
<!-- counter -->
<div class="container max-w-[1600px] my-16 sm:my-24 lg:my-[120px]">
    <div class="bg-primary px-10 py-[60px] rounded-[20px]">
        <div class="grid grid-cols-12 divide-y lg:divide-y-0 lg:divide-x rtl:lg:divide-x-reverse divide-white/15">
            <div
                class="col-span-full lg:col-span-3 [&:not(:first-child)]:pt-4 [&:not(:first-child)]:lg:pt-0 [&:not(:first-child)]:lg:pl-4 [&:not(:first-child)]:mt-4 [&:not(:first-child)]:lg:mt-0 [&:not(:first-child)]:lg:ml-4">
                <div class="flex-center flex-col gap-3.5">
                    <div class="text-white text-lg font-bold leading-none">
                        <?php echo e(translate($totalCourseText)); ?>

                    </div>
                    <h6 class="text-white text-[54px] font-extrabold leading-none">
                        <?php echo e($totalCourse > 1 ? $totalCourse . '+' : $totalCourse); ?>

                    </h6>
                </div>
            </div>
            <div
                class="col-span-full lg:col-span-3 [&:not(:first-child)]:pt-4 [&:not(:first-child)]:lg:pt-0 [&:not(:first-child)]:lg:pl-4 [&:not(:first-child)]:mt-4 [&:not(:first-child)]:lg:mt-0 [&:not(:first-child)]:lg:ml-4">
                <div class="flex-center flex-col gap-3.5">
                    <div class="text-white text-lg font-bold leading-none">
                        <?php echo e(translate('Years Experience')); ?>

                    </div>
                    <h6 class="text-white text-[54px] font-extrabold leading-none">
                        <?php echo e($totalExperience > 1 ? $totalExperience . '+' : 0); ?>

                    </h6>
                </div>
            </div>
            <div
                class="col-span-full lg:col-span-3 [&:not(:first-child)]:pt-4 [&:not(:first-child)]:lg:pt-0 [&:not(:first-child)]:lg:pl-4 [&:not(:first-child)]:mt-4 [&:not(:first-child)]:lg:mt-0 [&:not(:first-child)]:lg:ml-4">
                <div class="flex-center flex-col gap-3.5">
                    <div class="text-white text-lg font-bold leading-none">
                        <?php echo e(translate($totalTutorText)); ?>

                    </div>
                    <h6 class="text-white text-[54px] font-extrabold leading-none">
                        <?php echo e($totalTutor > 1 ? $totalTutor . '+' : $totalTutor); ?>

                    </h6>
                </div>
            </div>
            <div
                class="col-span-full lg:col-span-3 [&:not(:first-child)]:pt-4 [&:not(:first-child)]:lg:pt-0 [&:not(:first-child)]:lg:pl-4 [&:not(:first-child)]:mt-4 [&:not(:first-child)]:lg:mt-0 [&:not(:first-child)]:lg:ml-4">
                <div class="flex-center flex-col gap-3.5">
                    <div class="text-white text-lg font-bold leading-none">
                        <?php echo e(translate($totalStudentText)); ?>

                    </div>
                    <h6 class="text-white text-[54px] font-extrabold leading-none">
                        <?php echo e($totalStudent > 1 ? $totalStudent . '+' : $totalStudent); ?>

                    </h6>
                </div>
            </div>
        </div>
    </div>
</div>
<?php /**PATH D:\www\edulab\Modules\LMS\resources\views\components\counter\counter-one.blade.php ENDPATH**/ ?>