<?php
    $startTopicId = $start_topic_id ?? null;
    $auth = $auth ?? '';
    $purchaseCheck = $purchaseCheck ?? '';
    if ($auth && $purchaseCheck !== false) {
        $route = route('play.course', [
            'slug' => $course->slug,
            'topic_id' => $topic->id,
            'type' => $topic->topic_type?->slug,
            'chapter_id' => $chapterId ?? null,
        ]);
    } else {
        $route = '#';
    }
?>
<div class="border-t border-border hover:bg-slate-200 relative <?php echo e($startTopicId == $topic->id ? 'active' : ''); ?>">

    <a href="<?php echo e($sideBarShow == 'video-play' ? '#' : $route); ?>"
        class=" flex flex-col gap-2 px-3 py-4 leading-none cursor-pointer <?php echo e($sideBarShow == 'video-play' ? 'video-lesson-item' : ''); ?>"
        aria-label="<?php echo e($topic->title); ?>" data-type="<?php echo e($sideBarShow == 'video-play' ? $topic->topic_type?->slug : ''); ?>"
        data-id="<?php echo e($sideBarShow == 'video-play' ? $topic->id : ''); ?>"
        data-action="<?php echo e($sideBarShow == 'video-play' ? route('learn.course.topic') . '?course_id=' . $course->id . '&chapter_id=' . $topic?->chapter_id . '&topic_id=' . $topic->id : ''); ?>">
        <h6 class="text-sm font-normal">
            <?php echo e($key + 1); ?>.
            <?php echo e($topic->title); ?> (<?php echo e($topic?->topic_type?->slug); ?>)
        </h6>
        <?php if($topic->duration): ?>
            <div class="flex items-center gap-1 ml-4 text-xs text-slate-900">
                <?php echo $icon ?? ''; ?>

                <?php echo e($topic->duration); ?><?php echo e(translate('min')); ?>

            </div>
        <?php endif; ?>
    </a>

    <?php if(!$auth || ($auth && $purchaseCheck == false)): ?>
        <span class="absolute top-1/2 -translate-y-1/2 right-2 rtl:right-auto rtl:left-2 text-heading">
            <i class="ri-lock-line"></i>
        </span>
    <?php endif; ?>
</div>
<?php /**PATH D:\www\edulab\Modules\LMS\resources\views\components\course\curriculum-item\item.blade.php ENDPATH**/ ?>