<?php if(isset($paginator) && $paginator->hasPages()): ?>
    <div class="flex-center mt-12">
        <div class="flex sm:gap-2.5 gap-1 page-item">
            <?php if(!$paginator->onFirstPage()): ?>
                <a class="pagi-btn disabled" href="<?php echo e($paginator->previousPageUrl()); ?>" aria-label="pagination link" >
                    <i class="ri-arrow-left-line rtl:before:content-['\ea6c'] text-inherit"></i>
                </a>
            <?php endif; ?>
            <?php $__currentLoopData = $elements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $element): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if(is_string($element)): ?>
                    <button type="button" aria-label="pagination link" class="pagi-btn disabled" aria-current="page"><?php echo e($element); ?></button>
                <?php endif; ?>
                <?php if(is_array($element)): ?>
                    <?php $__currentLoopData = $element; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page => $url): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if($page == $paginator->currentPage()): ?>
                            <button type="button" aria-label="Current page" class="page-link pagi-btn active"><?php echo e($page); ?></button>
                        <?php else: ?>
                            <a class="page-link pagi-btn" aria-label="pagination link" href="<?php echo e($url); ?>"><?php echo e($page); ?></a>
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            <?php if($paginator->hasMorePages()): ?>
                <a class="pagi-btn page-link" href="<?php echo e($paginator->nextPageUrl()); ?>" aria-label="pagination link" >
                    <i class="ri-arrow-right-line rtl:before:content-['\ea60'] text-inherit"></i>
                </a>
            <?php else: ?>
                <button type="button" class="pagi-btn" aria-label="pagination link" >
                    <i class="ri-arrow-right-line rtl:before:content-['\ea60'] text-inherit"></i>
                </button>
            <?php endif; ?>

        </div>
    </div>
<?php endif; ?>
<?php /**PATH D:\www\edulab\Modules\LMS\resources\views\theme\pagination\pagination-two.blade.php ENDPATH**/ ?>