<?php
    $locale = request()->locale ?? app()->getLocale();
    $translations = [];
    $testimonial = $testimonial ?? null;
    if ($testimonial && $locale) {
        $translations = parse_translation($testimonial, $locale);
    }
?>

<?php if (isset($component)) { $__componentOriginald7f77a02f879fd4954ea3c39c4e952cb = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginald7f77a02f879fd4954ea3c39c4e952cb = $attributes; } ?>
<?php $component = Modules\LMS\View\Components\Dashboard\Layout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('dashboard-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Modules\LMS\View\Components\Dashboard\Layout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('title', null, []); ?> 
        <?php echo e(isset($testimonial) ? translate('Edit Testimonial') : translate('Create Testimonial')); ?>

     <?php $__env->endSlot(); ?>
    <!-- BREADCRUMB -->
    <?php if (isset($component)) { $__componentOriginalcf27f2c2c873893339708d5fdeeb6984 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalcf27f2c2c873893339708d5fdeeb6984 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => '7ee9c4f86007ba41bc79bbfab1cd8a68::admin.breadcrumb','data' => ['backUrl' => ''.e(route('testimonial.index')).'','title' => ''.e(isset($testimonial) ? 'Edit' : 'Create').'','pageTo' => 'Testimonial']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('portal::admin.breadcrumb'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['back-url' => ''.e(route('testimonial.index')).'','title' => ''.e(isset($testimonial) ? 'Edit' : 'Create').'','page-to' => 'Testimonial']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalcf27f2c2c873893339708d5fdeeb6984)): ?>
<?php $attributes = $__attributesOriginalcf27f2c2c873893339708d5fdeeb6984; ?>
<?php unset($__attributesOriginalcf27f2c2c873893339708d5fdeeb6984); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalcf27f2c2c873893339708d5fdeeb6984)): ?>
<?php $component = $__componentOriginalcf27f2c2c873893339708d5fdeeb6984; ?>
<?php unset($__componentOriginalcf27f2c2c873893339708d5fdeeb6984); ?>
<?php endif; ?>
    <?php if(is_active('testimonial.translate') === 'active'): ?>
    <div class="flex items-center justify-end gap-4 mb-2">
        <h2 class="card-title"><?php echo e(translate('Translate Language')); ?></h2>
        <form method="GET" class="sm:block" id="change-translate-language">
            <select onchange="window.location.href=this.options[this.selectedIndex].value" name="id"
                class="text-gray-500 dark:text-dark-text dark:bg-dark-card-shade font-semibold bg-white focus:outline-none cursor-pointer select-none text-sm border dk-border-one px-2 py-2 rounded-md dk-theme-card-square">
                <?php $__currentLoopData = app('languages'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($lang->code); ?>"
                        <?php echo e(isset($locale) && $locale == $lang->code ? 'selected' : ''); ?>>
                        <?php echo e($lang->name); ?>

                    </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </form>
    </div>
    <?php endif; ?>
    <form action="<?php echo e(isset($testimonial) ? route('testimonial.update', $testimonial->id) : route('testimonial.store')); ?>"
        method="POST" class="form" enctype="multipart/form-data">
        <?php echo csrf_field(); ?>
        <?php if(isset($testimonial)): ?>
            <?php echo method_field('put'); ?>
        <?php endif; ?>
        <input type="hidden" name="locale" class="form-input" value="<?php echo e($locale ?? ''); ?>">
        <div class="grid grid-cols-12 gap-x-4">
            <div class="col-span-full md:col-span-7 card">
                <div class="p-1.5">
                    <h6 class="leading-none text-xl font-semibold text-heading">
                        <?php echo e(isset($testimonial) ? translate('Edit Testimonial') : translate('Add New Testimonial')); ?>

                    </h6>
                    <div class="mt-7">
                        <div>
                            <label for="testimonial-name" class="form-label"><?php echo e(translate('Name')); ?><span
                                    class="text-danger"
                                    title="<?php echo e(translate('This field is required')); ?>"><b>*</b></span></label>
                            <input type="text" id="testimonial-name" placeholder="<?php echo e(translate('Enter Your Name')); ?>"
                                name="name" class="form-input"
                                value="<?php echo e($translations['name'] ?? $testimonial->name ?? ''); ?>">
                            <span class="text-danger error-text name_err"></span>
                        </div>
                        <div class="mt-6">
                            <label for="designation" class="form-label"><?php echo e(translate('Designation')); ?><span
                                    class="text-danger"
                                    title="<?php echo e(translate('This field is required')); ?>"><b>*</b></span></label>
                            <input type="text" id="designation"
                                placeholder="<?php echo e(translate('Enter Your Designation')); ?>" class="form-input"
                                name="designation"
                                value="<?php echo e($translations['designation'] ?? $testimonial->designation ?? ''); ?>" />
                            <span class="text-danger error-text designation_err"></span>
                        </div>
                        <div class="mt-6">
                            <label for="rating" class="form-label"><?php echo e(translate('Rating')); ?><span class="text-danger"
                                    title="<?php echo e(translate('This field is required')); ?>"><b>*</b></span></label>
                            <input type="text" id="rating"
                                placeholder="<?php echo e(translate('Enter your Rating out of 5')); ?>" name="rating"
                                class="form-input" value="<?php echo e($translations['rating'] ?? $testimonial->rating ?? ''); ?>">
                            <span class="text-danger error-text rating_err"></span>
                        </div>
                        <div class="mt-6">
                            <label for="testimonial-content" class="form-label"><?php echo e(translate('Description')); ?></label>
                            <textarea class="summernote form-input" name="comments"><?php echo clean($translations['comments'] ?? $testimonial->comments ?? ''); ?></textarea>
                        </div>
                    </div>

                </div>
            </div>
            <?php if(is_active('testimonial.translate') !== 'active'): ?>
            <div class="col-span-full md:col-span-5 card">
                <h6 class="leading-none text-xl font-semibold text-heading"><?php echo e(translate('Media')); ?></h6>
                <div class="mt-7">
                    <p class="text-xs text-gray-500 dark:text-dark-text leading-none font-semibold mb-3">
                        <?php echo e(translate('Image')); ?>(<?php echo e(translate('200')); ?>x<?php echo e(translate('200')); ?>)
                        <span class="text-danger" title="<?php echo e(translate('This field is required')); ?>"><b>*</b></span>
                    </p>
                    <label for="imgage"
                        class="dropzone-wrappe file-container ac-bg text-xs leading-none font-semibold mb-3 cursor-pointer w-full h-[200px] flex flex-col items-center justify-center gap-2.5 border border-dashed border-gray-900 rounded-10 dk-theme-card-square">
                        <input type="file" hidden name="image" id="imgage"
                            class="dropzone dropzone-image img-src peer/file">
                        <span class="flex-center flex-col peer-[.uploaded]/file:hidden">
                            <img src="<?php echo e(asset('lms/')); ?>/assets/images/icons/upload-file.svg" alt="file-icon"
                                class="size-8 lg:size-auto">
                            <div class="text-gray-500 dark:text-dark-text mt-2">
                                <?php echo e(translate('Choose file')); ?>

                            </div>
                        </span>
                        <span class="text-danger error-text image_err"></span>
                    </label>
                    <div class="preview-zone dropzone-preview">
                        <div class="box box-solid">
                            <div class="box-body flex items-center gap-2 flex-wrap">
                                <?php if(isset($testimonial) && fileExists('lms/testimonials', $testimonial->profile_image) == true &&
                                            $testimonial->profile_image != ''): ?>
                                    <div class="img-thumb-wrapper">
                                        <img class="img-thumb" width="100"
                                            src="<?php echo e(asset('storage/lms/testimonials/' . $testimonial->profile_image)); ?>" />
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php endif; ?>
        </div>
        <div class="card flex-center justify-end">
            <button type="submit" class="btn b-solid btn-primary-solid dk-theme-card-square">
                <?php echo e(isset($testimonial) ? translate('Update') : translate('Submit')); ?>

            </button>
        </div>
    </form>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginald7f77a02f879fd4954ea3c39c4e952cb)): ?>
<?php $attributes = $__attributesOriginald7f77a02f879fd4954ea3c39c4e952cb; ?>
<?php unset($__attributesOriginald7f77a02f879fd4954ea3c39c4e952cb); ?>
<?php endif; ?>
<?php if (isset($__componentOriginald7f77a02f879fd4954ea3c39c4e952cb)): ?>
<?php $component = $__componentOriginald7f77a02f879fd4954ea3c39c4e952cb; ?>
<?php unset($__componentOriginald7f77a02f879fd4954ea3c39c4e952cb); ?>
<?php endif; ?>
<?php /**PATH D:\www\edulab\Modules\LMS\resources\views\portals\admin\testimonial\create.blade.php ENDPATH**/ ?>