<?php
    $response =
        get_theme_option('poster' . active_language()) ?:
        get_theme_option('posteren') ?? get_theme_option('postere' . app('default_language'));
    $posters = $response['poster'] ?? [];
    $defaultBanner = 'lms/frontend/assets/images/poster/become-a-student.png';
    $bannerPath = 'storage/lms/theme-options';

?>

<?php if(is_iterable($posters) && count($posters) > 0): ?>
    <div class="bg-white pt-16 sm:pt-24 lg:pt-[120px]">
        <div class="container">
            <div class="grid grid-cols-12 gap-4 xl:gap-7">
                <?php $__currentLoopData = $posters; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $poster): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-span-full lg:col-span-6">
                        <?php
                            $posterImage = $poster['poster_img'] ?? '';
                            $bannerImage =
                                $posterImage && fileExists('lms/theme-options', $posterImage) == true
                                    ? asset("$bannerPath/{$posterImage}")
                                    : asset($defaultBanner);
                        ?>
                        <div 
                            class="flex flex-col <?php echo e($loop->iteration % 2 == 0 ? 'bg-secondary text-heading' : 'bg-primary text-white'); ?> bg-no-repeat bg-cover bg-right h-[300px] px-10 py-12 pb-[60px] rtl:rotate-xz-180"
                            style='<?php echo e($bannerImage ? "background-image: url( $bannerImage)" : ''); ?>'
                        >
                            <div class="rtl:rotate-xz-180">
                                <h3 class="area-title lg:text-3xl text-inherit">
                                    <?php echo e($poster['title'] ?? ''); ?>

                                </h3>
                                <p class="area-description mt-3 text-inherit sm:max-w-[60%]">
                                    <?php echo e($poster['description'] ?? ''); ?>

                                </p>
                                <a href="<?php echo e($poster['button_link'] ?? '#'); ?>" aria-label="Poster call to action"
                                    class="btn b-solid <?php echo e($loop->iteration % 2 == 0 ? 'btn-primary-solid' : 'btn-secondary-solid'); ?> btn-lg !rounded-none mt-11">
                                    <?php echo e($poster['button_label'] ?? translate('Learn More')); ?>

                                </a>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>
<?php endif; ?>
<?php /**PATH D:\www\edulab\Modules\LMS\resources\themes\elearning-education\components\poster\poster-banner.blade.php ENDPATH**/ ?>