<?php if($paginator->hasPages()): ?>
    <div class="flex-center-between flex-wrap gap-4 border-t-[0.5px] border-gray-200 dark:border-dark-border pt-4">
        <div class="leading-none text-xs font-semibold text-gray-900">
            <?php echo e(translate('Showing')); ?> <?php echo e($paginator->firstItem()); ?> <?php echo e(translate('to')); ?> <?php echo e($paginator->lastItem()); ?>

            <?php echo e(translate('of')); ?>

            <?php echo e($paginator->total()); ?>

            <?php echo e(translate('entries')); ?>

        </div>
        <ul class="grow flex items-center justify-end gap-2 *:text-xs *:text-gray-900">
            <?php if($paginator->onFirstPage()): ?>
                <li class="hl-pagination--item disabled"> <a class="hl-pagination--button" href="#"
                        tabindex="-1"></a> </li>
            <?php else: ?>
                <li>
                    <a href="<?php echo e($paginator->previousPageUrl()); ?>"
                        class="size-8 border-[0.5px] hover:border-transparent border-gray-900/50 rounded-sm flex-center hover:bg-primary-500 hover:text-white text-gray-900 ac-transition">
                        <i class="ri-arrow-left-line text-inherit"></i>
                    </a>
                </li>
            <?php endif; ?>

            <?php $__currentLoopData = $elements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $element): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if(is_string($element)): ?>
                    <li class="page-item disabled" aria-current="page"><?php echo e($element); ?></li>
                <?php endif; ?>
                <?php if(is_array($element)): ?>
                    <?php $__currentLoopData = $element; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page => $url): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if($page == $paginator->currentPage()): ?>
                            <li>
                                <a href="#"
                                    class="size-8 border-[0.5px] hover:border-transparent [&.active]:border-transparent border-gray-900/50 rounded-sm flex-center hover:bg-primary-500 [&.active]:bg-primary-500 hover:text-white [&.active]:text-white text-gray-900 ac-transition active">
                                    <?php echo e($page > 9 ? $page : "0$page"); ?></a>
                            </li>
                        <?php else: ?>
                            <li>
                                <a href="<?php echo e($url); ?>"
                                    class="size-8 border-[0.5px] hover:border-transparent [&.active]:border-transparent border-gray-900/50 rounded-sm flex-center hover:bg-primary-500 [&.active]:bg-primary-500 hover:text-white [&.active]:text-white text-gray-900 ac-transition">
                                    <?php echo e($page > 9 ? $page : "0$page"); ?></a>
                            </li>
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php if($paginator->hasMorePages()): ?>
                <li>
                    <a href="<?php echo e($paginator->nextPageUrl()); ?>"
                        class="size-8 border-[0.5px] hover:border-transparent border-gray-900/50 rounded-sm flex-center hover:bg-primary-500 hover:text-white text-gray-900 ac-transition disabled">
                        <i class="ri-arrow-right-line text-inherit"></i>
                    </a>
                </li>
            <?php else: ?>
                <li>
                    <a href="<?php echo e($paginator->nextPageUrl()); ?>"
                        class="size-8 border-[0.5px] hover:border-transparent border-gray-900/50 rounded-sm flex-center hover:bg-primary-500 hover:text-white text-gray-900 ac-transition">
                        <i class="ri-arrow-right-line text-inherit"></i>
                    </a>
                </li>
            <?php endif; ?>
        </ul>
    </div>
<?php endif; ?>
<?php /**PATH D:\www\edulab\Modules\LMS\resources\views\portals\admin\pagination\paginate.blade.php ENDPATH**/ ?>