<?php
    $class = $data['class'] ?? [];
    $btn = $data['btn'] ?? [];
?>

<form action="<?php echo e(route('auth.register')); ?>" class="mt-6 form">
    <?php echo csrf_field(); ?>
    <input type="hidden" name="user_type" value="instructor">
    <div class="grid grid-cols-2 gap-x-3 gap-y-4">
        <div class="col-span-full lg:col-auto">
            <div class="relative">
                <input type="text" id="instructor-first-name" name="first_name"
                    class="<?php echo e($class['input_class'] ?? 'form-input rounded-full peer'); ?>" placeholder="" />
                <label for="instructor-first-name" class="form-label floating-form-label">
                    <?php echo e(translate('First Name')); ?> <span class="text-danger"> *</span>
                </label>
            </div>
            <span class="text-danger error-text mt-1 d-block first_name_err"></span>
        </div>
        <div class="col-span-full lg:col-auto">
            <div class="relative">
                <input type="text" id="instructor-last-name" name="last_name"
                    class="<?php echo e($class['input_class'] ?? 'form-input rounded-full peer'); ?>" placeholder="" />
                <label for="instructor-last-name" class="form-label floating-form-label">
                    <?php echo e(translate('Last Name')); ?> <span class="text-danger"> *</span>
                </label>
            </div>
            <span class="text-danger error-text mt-1 d-block last_name_err"></span>
        </div>
        <div class="col-span-full lg:col-auto">
            <div class="relative">
                <input type="email" id="instructor-email" name="email"
                    class="<?php echo e($class['input_class'] ?? 'form-input rounded-full peer'); ?>" placeholder="" />
                <label for="instructor-email" class="form-label floating-form-label">
                    <?php echo e(translate('Email')); ?> <span class="text-danger"> *</span>
                </label>
            </div>
            <span class="text-danger error-text mt-1 d-block email_err"></span>
        </div>
        <div class="col-span-full lg:col-auto">
            <div class="relative">
                <input type="text" id="instructor-phone" name="phone"
                    class="<?php echo e($class['input_class'] ?? 'form-input rounded-full peer'); ?>" placeholder="" />
                <label for="instructor-phone" class="form-label floating-form-label">
                    <?php echo e(translate('Phone')); ?> <span class="text-danger"> *</span>
                </label>
            </div>
            <span class="text-danger error-text mt-1 d-block phone_err"></span>
        </div>
        <div class="col-span-full lg:col-auto">
            <div class="relative">
                <input type="password" id="password" name="password"
                    class="<?php echo e($class['input_class'] ?? 'form-input rounded-full peer'); ?>" placeholder="" />
                <label for="password" class="form-label floating-form-label">
                    <?php echo e(translate('Password')); ?> <span class="text-danger"> *</span>
                </label>
            </div>
            <span class="text-danger error-text mt-1 d-block password_err"></span>
        </div>
        <div class="col-span-full lg:col-auto">
            <div class="relative">
                <input type="password" id="password-confirmation" name="password_confirmation"
                    class="<?php echo e($class['input_class'] ?? 'form-input rounded-full peer'); ?>" placeholder="" />
                <label for="password-confirmation" class="form-label floating-form-label">
                    <?php echo e(translate('Confirm Password')); ?> <span class="text-danger"> *</span>
                </label>
            </div>
            <span class="text-danger error-text mt-1 d-block password_confirmation_err"></span>
        </div>

        <div class="col-span-full">
            <div class="relative">
                <input type="text" id="designation" name="designation"
                    class="<?php echo e($class['input_class'] ?? 'form-input rounded-full peer'); ?>" placeholder="" />
                <label for="designation" class="form-label floating-form-label">
                    <?php echo e(translate('Designation')); ?> <span class="text-danger"> *</span>
                </label>
            </div>
            <span class="text-danger error-text mt-1 d-block designation_err"></span>
        </div>
        <div class="col-span-full">
            <div class="relative">
                <textarea id="instructor-education" name="about" rows="5"
                    class="<?php echo e($class['input_class'] ?? 'form-input peer'); ?> !rounded-2xl !h-auto" placeholder=""></textarea>
                <label for="instructor-education" class="form-label floating-form-label">
                    <?php echo e(translate('About')); ?>

                </label>
            </div>
        </div>
        <div class="col-span-full">
            <button type="submit"
                class=" <?php echo e($class['btn_class'] ?? 'btn b-solid btn-secondary-solid !text-heading btn-xl !rounded-full font-bold w-full'); ?>"
                aria-label="Join as Instructor">
                <?php echo e(translate($btn['text'] ?? 'Join as Instructor')); ?>

                <?php if($btn['is_show_icon'] ?? true): ?>
                    <span class="hidden md:block">
                        <i class="ri-arrow-right-up-line text-[20px] rtl:before:content-['\ea66']"></i>
                    </span>
                <?php endif; ?>
            </button>
        </div>
    </div>
</form>
<?php /**PATH D:\www\edulab\Modules\LMS\resources\views\components\form\join-us\form.blade.php ENDPATH**/ ?>