<?php
    $userInfo = $user->userable ?? null;

    if ($userInfo) {
        $userTranslations = parse_translation($userInfo);
    }

    $coverImg =
        $userInfo->cover_photo && fileExists('lms/instructors', $userInfo->cover_photo) == true
            ? asset("storage/lms/instructors/{$userInfo->cover_photo}")
            : asset('lms/frontend/assets/images/870x260.svg');

    $profileImg =
        $userInfo?->profile_img && fileExists('lms/instructors', $userInfo?->profile_img) == true
            ? asset("storage/lms/instructors/{$userInfo?->profile_img}")
            : asset('lms/frontend/assets/images/370x396.svg');

    if ($userTranslations) {
        $name = $userTranslations['first_name'] . ' ' . $userTranslations['last_name'];
    }
    if ($userInfo?->designation) {
        $designationData = parse_translation($userInfo?->designation);
    }

?>

<?php if (isset($component)) { $__componentOriginal4ea3ceba530d619a977e9c813ff095c4 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal4ea3ceba530d619a977e9c813ff095c4 = $attributes; } ?>
<?php $component = Modules\LMS\View\Components\Frontend\Layout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('frontend-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Modules\LMS\View\Components\Frontend\Layout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
    <?php if (isset($component)) { $__componentOriginal633e9714cbfc155a1e1afb58682cfb8f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal633e9714cbfc155a1e1afb58682cfb8f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'f484570d7cf557020e11ace406901b10::breadcrumbs.breadcrumb-one','data' => ['pageTitle' => 'Instructor Profile','pageRoute' => '#','pageName' => 'Instructor Profile']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('theme::breadcrumbs.breadcrumb-one'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['pageTitle' => 'Instructor Profile','pageRoute' => '#','pageName' => 'Instructor Profile']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal633e9714cbfc155a1e1afb58682cfb8f)): ?>
<?php $attributes = $__attributesOriginal633e9714cbfc155a1e1afb58682cfb8f; ?>
<?php unset($__attributesOriginal633e9714cbfc155a1e1afb58682cfb8f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal633e9714cbfc155a1e1afb58682cfb8f)): ?>
<?php $component = $__componentOriginal633e9714cbfc155a1e1afb58682cfb8f; ?>
<?php unset($__componentOriginal633e9714cbfc155a1e1afb58682cfb8f); ?>
<?php endif; ?>

    <!-- START INSTRUCTOR PROFILE AREA -->
    <div class="container">
        <div class="flex-center flex-col">
            <div class="w-full h-28 md:h-52 bg-no-repeat bg-cover bg-center"
                style="background-image: url(<?php echo e($coverImg); ?>);">
            </div>
            <div class="flex-center flex-col -mt-20 gap-2">
                <div class="size-40 md:size-44 rounded-50 overflow-hidden border-4 border-white">
                    <img data-src="<?php echo e($profileImg); ?>" alt="Instructor profile image" class="size-full object-cover">
                </div>
                <h6 class="area-title text-xl !leading-none font-bold mt-2">
                    <?php echo e($name ?? $userInfo->first_name . ' ' . $userInfo->last_name); ?>

                </h6>
                <ul
                    class="flex items-center flex-wrap gap-1.5 *:flex-center *:gap-1.5 leading-none text-heading/70 dark:text-dark-text">
                    <li
                        class="after:font-remix after:flex-center after:font-thin after:text-heading/70 after:size-5 after:content-['\f3c1'] after:text-[6px] after:translate-y-[1.4px] last:after:hidden">
                        <?php echo e($user->courses?->count() ?? 0); ?> <?php echo e(translate('Courses')); ?>

                    </li>

                    <li
                        class="after:font-remix after:flex-center after:font-thin after:text-heading/70 after:size-5 after:content-['\f3c1'] after:text-[6px] after:translate-y-[1.4px] last:after:hidden">
                        <?php echo e(!empty($totalStudents) && $totalStudents?->count() ?? 0); ?> <?php echo e(translate('Students')); ?>

                    </li>
                </ul>
                <ul
                    class="flex items-center flex-wrap gap-1.5 *:flex-center *:gap-1.5 leading-none text-heading/70 dark:text-dark-text">
                    <li
                        class="after:font-remix after:flex-center after:font-thin after:text-heading/70 after:size-5 after:content-['\f3c1'] after:text-[6px] after:translate-y-[1.4px] last:after:hidden">
                        <div class="flex items-center gap-0.5 text-secondary">
                            <?php echo show_rating($rating['average_rating']); ?>

                        </div>
                        <p class="area-description text-sm !leading-none">
                            <?php echo e($rating['total'] ?? 0); ?></p>
                    </li>
                    <li
                        class="after:font-remix after:flex-center after:font-thin after:text-heading/70 after:size-5 after:content-['\f3c1'] after:text-[6px] after:translate-y-[1.4px] last:after:hidden">
                        <?php echo e($designationData['title'] ?? ($userInfo?->designation?->title ?? '')); ?>

                    </li>
                </ul>
            </div>
        </div>
        <div class="grid grid-cols-12 gap-5 mt-10 lg:mt-[60px]">
            <div class="col-span-full lg:col-span-6">
                <div class="border border-border rounded-2xl p-7">
                    <article>
                        <h2 class="area-title xl:text-3xl mb-5"><?php echo e(translate('Biography')); ?></h2>
                        <div class="text-heading/70 font-semibold leading-[1.55] [&>:not(:first-child)]:mt-6 mt-6">
                            <?php echo clean($userTranslations['about'] ?? ($userInfo->about ?? '')); ?>

                        </div>
                        <!-- SOCIAL MEDIA -->
                        <ul class="flex flex-col gap-4 mt-10">
                            <li>
                                <a href="mailto:<?php echo e($user->email); ?>" aria-label="Instructor mail"
                                    class="flex items-center gap-2 text-primary leading-none">
                                    <i class="ri-mail-send-line"></i>
                                    <span class="text-heading"> <?php echo e($user->email); ?></span>
                                </a>
                            </li>
                            <?php if($user->phone): ?>
                                <li>
                                    <a href="tel+<?php echo e($user->phone); ?>" aria-label="Instructor phone"
                                        class="flex items-center gap-2 text-primary leading-none">
                                        <i class="ri-phone-line"></i>
                                        <span class="text-heading">+ <?php echo e($user->phone); ?></span>
                                    </a>
                                </li>
                            <?php endif; ?>

                        </ul>
                    </article>
                </div>
            </div>
            <div class="col-span-full lg:col-span-6">
                <div class="border border-border rounded-2xl p-7">
                    <h2 class="area-title xl:text-3xl mb-5"><?php echo e(translate('Contact Form')); ?></h2>
                    <?php if (isset($component)) { $__componentOriginal42db8e8d890bef6ec12068d418ea343b = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal42db8e8d890bef6ec12068d418ea343b = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'f484570d7cf557020e11ace406901b10::contact-form.form','data' => ['userId' => ''.e($user->id).'']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('theme::contact-form.form'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['userId' => ''.e($user->id).'']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal42db8e8d890bef6ec12068d418ea343b)): ?>
<?php $attributes = $__attributesOriginal42db8e8d890bef6ec12068d418ea343b; ?>
<?php unset($__attributesOriginal42db8e8d890bef6ec12068d418ea343b); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal42db8e8d890bef6ec12068d418ea343b)): ?>
<?php $component = $__componentOriginal42db8e8d890bef6ec12068d418ea343b; ?>
<?php unset($__componentOriginal42db8e8d890bef6ec12068d418ea343b); ?>
<?php endif; ?>
                </div>
            </div>
        </div>
    </div>
    <!-- END INSTRUCTOR PROFILE AREA -->

    <!-- START MY COURSES AREA -->
    <?php
        $courses = $courses ?? [];
    ?>
    <?php if($courses && count($courses) > 0): ?>
        <?php if (isset($component)) { $__componentOriginal2e59a2e44dde0b7079f0a251e9190a15 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal2e59a2e44dde0b7079f0a251e9190a15 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'f484570d7cf557020e11ace406901b10::instructor.my-course','data' => ['courses' => $courses ?? []]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('theme::instructor.my-course'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['courses' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($courses ?? [])]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal2e59a2e44dde0b7079f0a251e9190a15)): ?>
<?php $attributes = $__attributesOriginal2e59a2e44dde0b7079f0a251e9190a15; ?>
<?php unset($__attributesOriginal2e59a2e44dde0b7079f0a251e9190a15); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal2e59a2e44dde0b7079f0a251e9190a15)): ?>
<?php $component = $__componentOriginal2e59a2e44dde0b7079f0a251e9190a15; ?>
<?php unset($__componentOriginal2e59a2e44dde0b7079f0a251e9190a15); ?>
<?php endif; ?>
    <?php endif; ?>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal4ea3ceba530d619a977e9c813ff095c4)): ?>
<?php $attributes = $__attributesOriginal4ea3ceba530d619a977e9c813ff095c4; ?>
<?php unset($__attributesOriginal4ea3ceba530d619a977e9c813ff095c4); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal4ea3ceba530d619a977e9c813ff095c4)): ?>
<?php $component = $__componentOriginal4ea3ceba530d619a977e9c813ff095c4; ?>
<?php unset($__componentOriginal4ea3ceba530d619a977e9c813ff095c4); ?>
<?php endif; ?>
<?php /**PATH D:\www\edulab\Modules\LMS\resources\views\theme\instructor\profile-details.blade.php ENDPATH**/ ?>